/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.builder;

import com.google.common.base.Preconditions;
import net.java.ao.DefaultSchemaConfiguration;
import net.java.ao.EntityManager;
import net.java.ao.EntityManagerConfiguration;
import net.java.ao.SchemaConfiguration;
import net.java.ao.builder.BuilderDatabaseProperties;
import net.java.ao.schema.CamelCaseFieldNameConverter;
import net.java.ao.schema.CamelCaseTableNameConverter;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.TableAnnotationTableNameConverter;
import net.java.ao.schema.TableNameConverter;

public abstract class AbstractEntityManagerBuilderWithDatabaseProperties<B extends AbstractEntityManagerBuilderWithDatabaseProperties> {
    private final BuilderDatabaseProperties databaseProperties;
    private final BuilderEntityManagerConfiguration configuration;

    AbstractEntityManagerBuilderWithDatabaseProperties(BuilderDatabaseProperties databaseProperties) {
        this(databaseProperties, new BuilderEntityManagerConfiguration());
    }

    AbstractEntityManagerBuilderWithDatabaseProperties(BuilderDatabaseProperties databaseProperties, BuilderEntityManagerConfiguration configuration) {
        this.databaseProperties = (BuilderDatabaseProperties)Preconditions.checkNotNull((Object)databaseProperties);
        this.configuration = (BuilderEntityManagerConfiguration)Preconditions.checkNotNull((Object)configuration);
    }

    public B schema(String schema) {
        this.databaseProperties.setSchema(schema);
        return this.cast();
    }

    public B tableNameConverter(TableNameConverter tableNameConverter) {
        this.configuration.setTableNameConverter((TableNameConverter)Preconditions.checkNotNull((Object)tableNameConverter));
        return this.cast();
    }

    public B fieldNameConverter(FieldNameConverter fieldNameConverter) {
        this.configuration.setFieldNameConverter((FieldNameConverter)Preconditions.checkNotNull((Object)fieldNameConverter));
        return this.cast();
    }

    public B schemaConfiguration(SchemaConfiguration schemaConfiguration) {
        this.configuration.setSchemaConfiguration(schemaConfiguration);
        return this.cast();
    }

    public B useWeakCache() {
        this.configuration.setUseWeakCache(true);
        return this.cast();
    }

    final BuilderDatabaseProperties getDatabaseProperties() {
        return this.databaseProperties;
    }

    final BuilderEntityManagerConfiguration getEntityManagerConfiguration() {
        return this.configuration;
    }

    public abstract EntityManager build();

    private B cast() {
        return (B)this;
    }

    static class BuilderEntityManagerConfiguration
    implements EntityManagerConfiguration {
        private SchemaConfiguration schemaConfiguration;
        private TableNameConverter tableNameConverter;
        private FieldNameConverter fieldNameConverter;
        private boolean useWeakCache = false;

        BuilderEntityManagerConfiguration() {
        }

        public boolean useWeakCache() {
            return this.useWeakCache;
        }

        public TableNameConverter getTableNameConverter() {
            return this.tableNameConverter != null ? this.tableNameConverter : BuilderEntityManagerConfiguration.defaultTableNameConverter();
        }

        private static TableNameConverter defaultTableNameConverter() {
            return new TableAnnotationTableNameConverter((TableNameConverter)new CamelCaseTableNameConverter());
        }

        public FieldNameConverter getFieldNameConverter() {
            return this.fieldNameConverter != null ? this.fieldNameConverter : BuilderEntityManagerConfiguration.defaultFieldNameConverter();
        }

        private static CamelCaseFieldNameConverter defaultFieldNameConverter() {
            return new CamelCaseFieldNameConverter();
        }

        public void setUseWeakCache(boolean useWeakCache) {
            this.useWeakCache = useWeakCache;
        }

        public void setTableNameConverter(TableNameConverter tableNameConverter) {
            this.tableNameConverter = tableNameConverter;
        }

        public void setFieldNameConverter(FieldNameConverter fieldNameConverter) {
            this.fieldNameConverter = fieldNameConverter;
        }

        public SchemaConfiguration getSchemaConfiguration() {
            return this.schemaConfiguration != null ? this.schemaConfiguration : new DefaultSchemaConfiguration();
        }

        public void setSchemaConfiguration(SchemaConfiguration schemaConfiguration) {
            this.schemaConfiguration = schemaConfiguration;
        }
    }
}

