/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.builder;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import net.java.ao.EntityManager;
import net.java.ao.EntityManagerConfiguration;
import net.java.ao.LuceneConfiguration;
import net.java.ao.builder.AbstractEntityManagerBuilderWithDatabaseProperties;
import net.java.ao.builder.BuilderDatabaseProperties;
import net.java.ao.builder.DatabaseProviderFactory;
import net.java.ao.builder.EntityManagerBuilderWithDatabasePropertiesAndLuceneConfiguration;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public final class EntityManagerBuilderWithDatabaseProperties
extends AbstractEntityManagerBuilderWithDatabaseProperties<EntityManagerBuilderWithDatabaseProperties> {
    EntityManagerBuilderWithDatabaseProperties(BuilderDatabaseProperties databaseProperties) {
        super(databaseProperties);
    }

    public EntityManagerBuilderWithDatabasePropertiesAndLuceneConfiguration withIndex(final File indexDir) {
        Objects.requireNonNull(indexDir, "indexDir can't be null");
        return new EntityManagerBuilderWithDatabasePropertiesAndLuceneConfiguration(this.getDatabaseProperties(), this.getEntityManagerConfiguration(), new LuceneConfiguration(){

            public Directory getIndexDirectory() {
                try {
                    return FSDirectory.getDirectory((File)indexDir);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public EntityManager build() {
        return new EntityManager(DatabaseProviderFactory.getDatabaseProvider(this.getDatabaseProperties()), (EntityManagerConfiguration)this.getEntityManagerConfiguration());
    }
}

