/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.jdbc;

import java.util.HashMap;
import java.util.Map;
import net.java.ao.test.jdbc.AbstractJdbcConfiguration;
import net.java.ao.test.jdbc.ConfigurationProperties;
import net.java.ao.test.jdbc.Hsql;
import net.java.ao.test.jdbc.JdbcConfiguration;
import net.java.ao.test.jdbc.MySql;
import net.java.ao.test.jdbc.Oracle;
import net.java.ao.test.jdbc.Postgres;

public final class DynamicJdbcConfiguration
extends AbstractJdbcConfiguration {
    private static final Map<String, JdbcConfiguration> AVAILABLE = new HashMap<String, JdbcConfiguration>(){
        {
            this.put("hsql", new Hsql());
            this.put("mysql", new MySql());
            this.put("postgres", new Postgres());
            this.put("oracle", new Oracle());
        }
    };
    private final JdbcConfiguration delegate;

    public DynamicJdbcConfiguration() {
        String database = ConfigurationProperties.get("ao.test.database", "hsql");
        this.delegate = this.get(database);
        if (this.delegate == null) {
            throw new IllegalStateException("Could not find appropriate database configuration for " + database);
        }
    }

    private JdbcConfiguration get(String database) {
        return AVAILABLE.get(database);
    }

    public String getUrl() {
        return this.delegate.getUrl();
    }

    public String getUsername() {
        return this.delegate.getUsername();
    }

    public String getPassword() {
        return this.delegate.getPassword();
    }
}

