/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.junit;

import java.util.LinkedList;
import java.util.List;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.test.NameConverters;
import net.java.ao.test.jdbc.Hsql;
import net.java.ao.test.jdbc.Jdbc;
import net.java.ao.test.jdbc.JdbcConfiguration;
import net.java.ao.test.junit.ActiveObjectTransactionMethodRule;
import net.java.ao.test.lucene.WithIndex;
import org.junit.rules.MethodRule;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class ActiveObjectsJUnitRunner
extends BlockJUnit4ClassRunner {
    private final JdbcConfiguration jdbcConfiguration;
    private final boolean withIndex;
    private TableNameConverter tableNameConverter;
    private FieldNameConverter fieldNameConverter;

    public ActiveObjectsJUnitRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.jdbcConfiguration = this.resolveJdbcConfiguration(klass);
        this.tableNameConverter = this.tableNameConverter(klass);
        this.fieldNameConverter = this.fieldNameConverter(klass);
        this.withIndex = this.withIndex(klass);
    }

    protected List<MethodRule> rules(Object test) {
        LinkedList<MethodRule> methodRules = new LinkedList<MethodRule>(super.rules(test));
        methodRules.add(new ActiveObjectTransactionMethodRule(test, this.jdbcConfiguration, this.withIndex, this.tableNameConverter, this.fieldNameConverter));
        return methodRules;
    }

    private boolean withIndex(Class<?> klass) {
        return klass.isAnnotationPresent(WithIndex.class);
    }

    private TableNameConverter tableNameConverter(Class<?> klass) {
        if (klass.isAnnotationPresent(NameConverters.class)) {
            return this.newInstance(klass.getAnnotation(NameConverters.class).table());
        }
        return null;
    }

    private FieldNameConverter fieldNameConverter(Class<?> klass) {
        if (klass.isAnnotationPresent(NameConverters.class)) {
            return this.newInstance(klass.getAnnotation(NameConverters.class).field());
        }
        return null;
    }

    private JdbcConfiguration resolveJdbcConfiguration(Class<?> klass) {
        if (klass.isAnnotationPresent(Jdbc.class)) {
            return this.newInstance(klass.getAnnotation(Jdbc.class).value());
        }
        return this.getDefaultJdbcConfiguration();
    }

    private <T> T newInstance(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private JdbcConfiguration getDefaultJdbcConfiguration() {
        return new Hsql();
    }
}

