/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.junit;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import net.java.ao.EntityManager;
import net.java.ao.builder.EntityManagerBuilder;
import net.java.ao.builder.EntityManagerBuilderWithDatabaseProperties;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.TableNameConverter;
import net.java.ao.test.jdbc.Data;
import net.java.ao.test.jdbc.DatabaseUpdater;
import net.java.ao.test.jdbc.JdbcConfiguration;
import net.java.ao.test.jdbc.NonTransactional;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class ActiveObjectTransactionMethodRule
implements MethodRule {
    private static final Map<JdbcConfiguration, Class<? extends DatabaseUpdater>> DATABASES = new HashMap<JdbcConfiguration, Class<? extends DatabaseUpdater>>();
    private final Object test;
    private final JdbcConfiguration jdbc;
    private final boolean withIndex;
    private final TableNameConverter tableNameConverter;
    private final FieldNameConverter fieldNameConverter;
    private EntityManager entityManager;
    private File indexDirectory;

    public ActiveObjectTransactionMethodRule(Object test, JdbcConfiguration jdbc, boolean withIndex, TableNameConverter tableNameConverter, FieldNameConverter fieldNameConverter) {
        this.test = test;
        this.jdbc = jdbc;
        this.withIndex = withIndex;
        this.tableNameConverter = tableNameConverter;
        this.fieldNameConverter = fieldNameConverter;
    }

    public final Statement apply(final Statement base, final FrameworkMethod method, Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ActiveObjectTransactionMethodRule.this.before(method);
                try {
                    boolean useTransaction = ActiveObjectTransactionMethodRule.this.useTransaction(method);
                    Connection c = null;
                    if (useTransaction) {
                        c = ActiveObjectTransactionMethodRule.this.entityManager.getProvider().startTransaction();
                    }
                    base.evaluate();
                    if (useTransaction) {
                        ActiveObjectTransactionMethodRule.this.entityManager.getProvider().rollbackTransaction(c);
                    }
                }
                finally {
                    ActiveObjectTransactionMethodRule.this.after(method);
                }
            }
        };
    }

    protected void before(FrameworkMethod method) throws Throwable {
        this.createIndexDir();
        this.entityManager = this.createEntityManager();
        this.injectEntityManager();
        this.updateDatabase();
    }

    private void createIndexDir() {
        try {
            this.indexDirectory = File.createTempFile("ao_test", "index");
            this.indexDirectory.delete();
            this.indexDirectory.mkdirs();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void after(FrameworkMethod method) {
        if (!this.useTransaction(method)) {
            DATABASES.remove(this.jdbc.getClass());
        }
        this.entityManager = null;
        this.removeIndexDir();
    }

    private boolean useTransaction(FrameworkMethod method) {
        return !method.getMethod().isAnnotationPresent(NonTransactional.class);
    }

    private void removeIndexDir() {
        this.removeFile(this.indexDirectory);
    }

    private void removeFile(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else {
            for (File f : file.listFiles()) {
                this.removeFile(f);
            }
            file.delete();
        }
    }

    private EntityManager createEntityManager() {
        EntityManagerBuilderWithDatabaseProperties entityManagerBuilder = EntityManagerBuilder.url((String)this.jdbc.getUrl()).username(this.jdbc.getUsername()).password(this.jdbc.getPassword()).auto();
        if (this.tableNameConverter != null) {
            entityManagerBuilder = (EntityManagerBuilderWithDatabaseProperties)entityManagerBuilder.tableNameConverter(this.tableNameConverter);
        }
        if (this.fieldNameConverter != null) {
            entityManagerBuilder = (EntityManagerBuilderWithDatabaseProperties)entityManagerBuilder.fieldNameConverter(this.fieldNameConverter);
        }
        return this.withIndex ? entityManagerBuilder.withIndex(this.indexDirectory).build() : entityManagerBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectEntityManager() {
        Field field = this.getEntityManagerField(this.getTestClass());
        boolean isFieldAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            try {
                field.set(this.test, this.entityManager);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            field.setAccessible(isFieldAccessible);
        }
    }

    private void updateDatabase() throws Exception {
        Class<? extends DatabaseUpdater> databaseUpdater;
        Class<? extends DatabaseUpdater> clazz = databaseUpdater = this.isDataAnnotationPresent() ? this.getDataAnnotationValue() : this.getDataAnnotationDefaultValue();
        if (!DATABASES.containsKey(this.jdbc) || !DATABASES.get(this.jdbc).equals(databaseUpdater)) {
            this.entityManager.migrate(new Class[0]);
            this.newInstance(databaseUpdater).update(this.entityManager);
            DATABASES.put(this.jdbc, databaseUpdater);
        }
    }

    private Class<? extends DatabaseUpdater> getDataAnnotationDefaultValue() throws NoSuchMethodException {
        @Data
        final class C {
            C() {
            }
        }
        return C.class.getAnnotation(Data.class).value();
    }

    private Class<? extends DatabaseUpdater> getDataAnnotationValue() {
        return this.getTestClass().getAnnotation(Data.class).value();
    }

    private boolean isDataAnnotationPresent() {
        return this.getTestClass().isAnnotationPresent(Data.class);
    }

    private <T> T newInstance(Class<T> aClass) {
        try {
            return aClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> getTestClass() {
        return this.test.getClass();
    }

    private Field getEntityManagerField(Class<?> aClass) {
        for (Field field : aClass.getDeclaredFields()) {
            if (!field.getType().equals(EntityManager.class)) continue;
            return field;
        }
        if (!aClass.getSuperclass().equals(Object.class)) {
            return this.getEntityManagerField(aClass.getSuperclass());
        }
        return null;
    }
}

