/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import net.java.ao.DatabaseProvider;
import net.java.ao.EntityManager;
import net.java.ao.RawEntity;
import net.java.ao.db.OracleDatabaseProvider;
import net.java.ao.sql.SqlUtils;
import net.java.ao.test.SqlTracker;
import net.java.ao.test.converters.DynamicFieldNameConverter;
import net.java.ao.test.converters.DynamicTableNameConverter;
import net.java.ao.test.converters.NameConverters;
import net.java.ao.test.jdbc.DynamicJdbcConfiguration;
import net.java.ao.test.jdbc.Jdbc;
import net.java.ao.test.junit.ActiveObjectsJUnitRunner;
import org.junit.runner.RunWith;

@RunWith(value=ActiveObjectsJUnitRunner.class)
@NameConverters(table=DynamicTableNameConverter.class, field=DynamicFieldNameConverter.class)
@Jdbc(value=DynamicJdbcConfiguration.class)
public abstract class ActiveObjectsIntegrationTest {
    protected EntityManager entityManager;

    protected final boolean isOracle() {
        return this.entityManager.getProvider() instanceof OracleDatabaseProvider;
    }

    protected final <T> T checkSqlExecuted(Callable<T> callable) throws Exception {
        return this.checkSql(true, callable);
    }

    protected final <T> T checkSqlNotExecuted(Callable<T> callable) throws Exception {
        return this.checkSql(false, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T checkSql(boolean executed, Callable<T> callable) throws Exception {
        DatabaseProvider provider = this.entityManager.getProvider();
        SqlTracker sqlTracker = new SqlTracker();
        try {
            provider.addSqlListener((DatabaseProvider.SqlListener)sqlTracker);
            T t = callable.call();
            Assert.assertEquals((boolean)executed, (boolean)sqlTracker.isSqlExecuted());
            T t2 = t;
            return t2;
        }
        finally {
            provider.removeSqlListener((DatabaseProvider.SqlListener)sqlTracker);
        }
    }

    protected final <E extends RawEntity<?>> E checkSqlExecutedWhenSaving(final E entity) throws Exception {
        return (E)((RawEntity)this.checkSqlExecuted(new Callable<E>(){

            @Override
            public E call() throws Exception {
                entity.save();
                return entity;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeUpdate(String sql, UpdateCallback callback) throws Exception {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.entityManager.getProvider().getConnection();
            statement = connection.prepareStatement(sql);
            callback.setParameters(statement);
            statement.executeUpdate();
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(statement, (Connection)connection);
            throw throwable;
        }
        SqlUtils.closeQuietly((Statement)statement, (Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeStatement(String sql, StatementCallback callback) throws Exception {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.entityManager.getProvider().getConnection();
            statement = connection.prepareStatement(sql);
            callback.setParameters(statement);
            resultSet = statement.executeQuery();
            callback.processResult(resultSet);
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuietly(resultSet, statement, (Connection)connection);
            throw throwable;
        }
        SqlUtils.closeQuietly((ResultSet)resultSet, (Statement)statement, (Connection)connection);
    }

    protected final String getTableName(Class<? extends RawEntity<?>> entityType) {
        return this.getTableName(entityType, true);
    }

    protected final String getTableName(Class<? extends RawEntity<?>> entityType, boolean escape) {
        String tableName = this.entityManager.getTableNameConverter().getName(entityType);
        return escape ? this.entityManager.getProvider().withSchema(tableName) : tableName;
    }

    protected final String getFieldName(Class<? extends RawEntity<?>> entityType, String methodName) {
        return this.entityManager.getFieldNameConverter().getName(this.findMethod(entityType, methodName));
    }

    protected final String getPolyFieldName(Class<? extends RawEntity<?>> entityType, String methodName) {
        return this.entityManager.getFieldNameConverter().getPolyTypeName(this.findMethod(entityType, methodName));
    }

    protected final String escapeFieldName(Class<? extends RawEntity<?>> entityType, String methodName) {
        return this.escapeKeyword(this.getFieldName(entityType, methodName));
    }

    protected final String escapePolyFieldName(Class<? extends RawEntity<?>> entityType, String methodName) {
        return this.escapeKeyword(this.getPolyFieldName(entityType, methodName));
    }

    private Method findMethod(Class<? extends RawEntity<?>> entityType, final String methodName) {
        return (Method)Iterables.find((Iterable)Lists.newArrayList((Object[])entityType.getMethods()), (Predicate)new Predicate<Method>(){

            public boolean apply(Method m) {
                return m.getName().equals(methodName);
            }
        });
    }

    protected final String escapeKeyword(String keyword) {
        return this.entityManager.getProvider().processID(keyword);
    }

    protected abstract class UpdateCallback
    implements StatementCallback {
        protected UpdateCallback() {
        }

        @Override
        public final void processResult(ResultSet resultSet) throws Exception {
        }
    }

    protected static interface StatementCallback {
        public void setParameters(PreparedStatement var1) throws Exception;

        public void processResult(ResultSet var1) throws Exception;
    }
}

