/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.junit;

import java.util.LinkedList;
import java.util.List;
import net.java.ao.test.jdbc.Hsql;
import net.java.ao.test.jdbc.Jdbc;
import net.java.ao.test.jdbc.JdbcConfiguration;
import net.java.ao.test.junit.ActiveObjectTransactionMethodRule;
import net.java.ao.test.lucene.WithIndex;
import org.junit.rules.MethodRule;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveObjectsJUnitRunner
extends BlockJUnit4ClassRunner {
    private final JdbcConfiguration jdbcConfiguration;
    private final boolean withIndex;

    public ActiveObjectsJUnitRunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.jdbcConfiguration = this.resolveJdbcConfiguration(klass);
        this.withIndex = this.withIndex(klass);
    }

    protected List<MethodRule> rules(Object test) {
        LinkedList<MethodRule> methodRules = new LinkedList<MethodRule>(super.rules(test));
        methodRules.add(new ActiveObjectTransactionMethodRule(test, this.jdbcConfiguration, this.withIndex));
        return methodRules;
    }

    private boolean withIndex(Class<?> klass) {
        return klass.isAnnotationPresent(WithIndex.class);
    }

    private JdbcConfiguration resolveJdbcConfiguration(Class<?> klass) {
        if (klass.isAnnotationPresent(Jdbc.class)) {
            try {
                return klass.getAnnotation(Jdbc.class).value().newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getDefaultJdbcConfiguration();
    }

    private JdbcConfiguration getDefaultJdbcConfiguration() {
        return new Hsql();
    }
}

