/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.converters;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import net.java.ao.schema.CamelCaseFieldNameConverter;
import net.java.ao.schema.FieldNameConverter;
import net.java.ao.schema.FieldNameProcessor;
import net.java.ao.test.ConfigurationProperties;
import net.java.ao.test.converters.TestFieldNameConverter;
import net.java.ao.test.converters.UpperCaseFieldNameConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicFieldNameConverter
implements FieldNameConverter,
FieldNameProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DynamicFieldNameConverter.class);
    private final Supplier<FieldNameConverter> fncSupplier = Suppliers.memoize((Supplier)new SystemPropertyFieldNameConverterSupplier());

    public String getName(Method method) {
        return ((FieldNameConverter)this.fncSupplier.get()).getName(method);
    }

    public String getPolyTypeName(Method method) {
        return ((FieldNameConverter)this.fncSupplier.get()).getPolyTypeName(method);
    }

    public String convertName(String name) {
        if (this.fncSupplier.get() instanceof FieldNameProcessor) {
            return ((FieldNameProcessor)this.fncSupplier.get()).convertName(name);
        }
        return name;
    }

    private static final class SystemPropertyFieldNameConverterSupplier
    implements Supplier<FieldNameConverter> {
        private static final String DEFAULT = "test";
        private final ImmutableMap<String, FieldNameConverter> converters = ImmutableMap.of((Object)"test", (Object)new TestFieldNameConverter(), (Object)"camelcase", (Object)new CamelCaseFieldNameConverter(), (Object)"uppercase", (Object)new UpperCaseFieldNameConverter());

        private SystemPropertyFieldNameConverterSupplier() {
        }

        public FieldNameConverter get() {
            String key = ConfigurationProperties.get("ao.test.fieldnameconverter", DEFAULT);
            FieldNameConverter fnc = (FieldNameConverter)this.converters.get((Object)key);
            logger.debug("Field name converter key is {} and resolved to {}", (Object)key, (Object)fnc.getClass().getName());
            return fnc;
        }
    }
}

