/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test;

import java.util.concurrent.Callable;
import net.java.ao.EntityManager;
import net.java.ao.RawEntity;
import net.java.ao.schema.ddl.DDLField;
import net.java.ao.schema.ddl.DDLTable;
import net.java.ao.test.DbUtils;
import net.java.ao.test.EntityUtils;
import net.java.ao.test.junit.ActiveObjectsJUnitRunner;
import org.junit.runner.RunWith;

@RunWith(value=ActiveObjectsJUnitRunner.class)
public abstract class ActiveObjectsIntegrationTest {
    protected EntityManager entityManager;

    protected final <T> T checkSqlExecuted(Callable<T> callable) throws Exception {
        return DbUtils.checkSqlExecuted(this.entityManager, callable);
    }

    protected final <T> T checkSqlNotExecuted(Callable<T> callable) throws Exception {
        return DbUtils.checkSqlNotExecuted(this.entityManager, callable);
    }

    protected final <E extends RawEntity<?>> E checkSqlExecutedWhenSaving(E entity) throws Exception {
        return DbUtils.checkSqlExecutedWhenSaving(this.entityManager, entity);
    }

    protected final void executeUpdate(String sql, DbUtils.UpdateCallback callback) throws Exception {
        DbUtils.executeUpdate(this.entityManager, sql, callback);
    }

    protected final void executeStatement(String sql, DbUtils.StatementCallback callback) throws Exception {
        DbUtils.executeStatement(this.entityManager, sql, callback);
    }

    protected final String getTableName(Class<? extends RawEntity<?>> entityType) {
        return EntityUtils.getTableName(this.entityManager, entityType);
    }

    protected final String getTableName(Class<? extends RawEntity<?>> entityType, boolean escape) {
        return EntityUtils.getTableName(this.entityManager, entityType, escape);
    }

    protected final String getFieldName(Class<? extends RawEntity<?>> entityType, String methodName) {
        return EntityUtils.getFieldName(this.entityManager, entityType, methodName);
    }

    protected final String getPolyFieldName(Class<? extends RawEntity<?>> entityType, String methodName) {
        return EntityUtils.getPolyFieldName(this.entityManager, entityType, methodName);
    }

    protected final String escapeFieldName(Class<? extends RawEntity<?>> entityType, String methodName) {
        return EntityUtils.escapeFieldName(this.entityManager, entityType, methodName);
    }

    protected final String escapePolyFieldName(Class<? extends RawEntity<?>> entityType, String methodName) {
        return EntityUtils.escapePolyFieldName(this.entityManager, entityType, methodName);
    }

    protected final String escapeKeyword(String keyword) {
        return EntityUtils.escapeKeyword(this.entityManager, keyword);
    }

    protected final DDLField findField(DDLTable table, String name) {
        for (DDLField field : table.getFields()) {
            if (!field.getName().equalsIgnoreCase(name)) continue;
            return field;
        }
        throw new IllegalStateException("Couldn't find field '" + name + "' in table '" + table.getName() + "'");
    }

    protected final DDLField findField(DDLTable table, Class<? extends RawEntity<?>> entityClass, String methodName) {
        return this.findField(table, this.getFieldName(entityClass, methodName));
    }

    static {
        System.setProperty("ao.atlassian.enforce.length", String.valueOf(false));
    }
}

