/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.jdbc;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import net.java.ao.test.ConfigurationProperties;
import net.java.ao.test.jdbc.AbstractJdbcConfiguration;
import net.java.ao.test.jdbc.DerbyEmbedded;
import net.java.ao.test.jdbc.Hsql;
import net.java.ao.test.jdbc.JdbcConfiguration;
import net.java.ao.test.jdbc.MySql;
import net.java.ao.test.jdbc.Oracle;
import net.java.ao.test.jdbc.Postgres;
import net.java.ao.test.jdbc.SqlServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicJdbcConfiguration
extends AbstractJdbcConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DynamicJdbcConfiguration.class);
    private static final ImmutableMap<String, JdbcConfiguration> CONFIGS = ImmutableMap.builder().put((Object)"hsql", (Object)new Hsql()).put((Object)"mysql", (Object)new MySql()).put((Object)"postgres", (Object)new Postgres()).put((Object)"oracle", (Object)new Oracle()).put((Object)"sqlserver", (Object)new SqlServer()).put((Object)"derby-embedded", (Object)new DerbyEmbedded()).build();
    private static final String DEFAULT = "hsql";
    private final Supplier<JdbcConfiguration> jdbcSupplier = Suppliers.memoize((Supplier)new SystemPropertyJdbcConfigurationSupplier());

    @Override
    public String getUrl() {
        return ((JdbcConfiguration)this.jdbcSupplier.get()).getUrl();
    }

    @Override
    public String getUsername() {
        return ((JdbcConfiguration)this.jdbcSupplier.get()).getUsername();
    }

    @Override
    public String getPassword() {
        return ((JdbcConfiguration)this.jdbcSupplier.get()).getPassword();
    }

    @Override
    public String getSchema() {
        return ((JdbcConfiguration)this.jdbcSupplier.get()).getSchema();
    }

    private static final class SystemPropertyJdbcConfigurationSupplier
    implements Supplier<JdbcConfiguration> {
        private SystemPropertyJdbcConfigurationSupplier() {
        }

        public JdbcConfiguration get() {
            String db = ConfigurationProperties.get("ao.test.database", DynamicJdbcConfiguration.DEFAULT);
            JdbcConfiguration jdbcConfiguration = (JdbcConfiguration)CONFIGS.get((Object)db);
            logger.debug("JDBC configuration key is {} and resolved to {}", (Object)db, (Object)jdbcConfiguration);
            return jdbcConfiguration;
        }
    }
}

