/*
 *  Licensed to the author under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.java.quickcheck.generator;

import net.java.quickcheck.Generator;

public  class Generators {
	
	private Generators(){}
	
	/**
	 * Cast a generator to a super type generator.
	 * <p>
	 * This method can be used to cast a generator of type Generator<A> to a
	 * generator of type Generator<B> given that A extends B. This operator is
	 * valid as all Generator instances are covariant (are pure producers).
	 * </p>
	 */
	@SuppressWarnings("unchecked")
	public static <T> Generator<T> cast(Generator<? extends T> generator){
		return (Generator<T>) generator;
	}
}
