/*
 *  Licensed to the author under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package net.java.quickcheck.generator.support;

import java.util.Collection;
import java.util.Iterator;

import net.java.quickcheck.Generator;
import net.java.quickcheck.StatefulGenerator;
import net.java.quickcheck.util.Assert;

public class EnsuredValuesGenerator<T> implements StatefulGenerator<T> {

	private final Collection<T> ensured;
	private final Generator<T> generator;
	private Iterator<T> iterator;

	public EnsuredValuesGenerator(Collection<T> values) {
		this(values, new FixedValuesGenerator<T>(values));
	}

	public EnsuredValuesGenerator(Collection<T> ensured, Generator<T> random) {
		Assert.notNull(ensured, "ensured");
		Assert.notEmpty(ensured, "ensured");
		Assert.notNull(random, "random");

		this.ensured = ensured;
		this.generator = random;
		reset();
	}

	@Override
	public T next() {
		return this.iterator.hasNext() ? this.iterator.next() : this.generator
				.next();
	}

	@Override
	public void reset() {
		iterator = ensured.iterator();
	}
}
