/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.manager.impl.javaee;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.Singleton;
import javax.ejb.Timeout;
import javax.ejb.TimerService;
import javax.inject.Inject;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import net.java.trueupdate.jax.rs.client.UpdateClient;
import net.java.trueupdate.manager.core.BasicUpdateManager;
import net.java.trueupdate.manager.core.UpdateInstaller;
import net.java.trueupdate.manager.spec.UpdateMessage;
import net.java.trueupdate.shed.SystemProperties;

@Singleton
public class UpdateManagerBean
extends BasicUpdateManager {
    private static final Logger logger = Logger.getLogger(UpdateManagerBean.class.getName());
    @Resource(name="connectionFactory")
    private ConnectionFactory connectionFactory;
    @Resource(name="destination", lookup="jms/TrueUpdate Agent")
    private Destination destination;
    private Connection connection;
    @Resource(name="updateServiceBaseUri")
    private String updateServiceBaseString;
    @Resource(name="checkUpdatesIntervalMinutes")
    private int checkUpdatesIntervalMinutes;
    @Resource(name="timerService")
    private TimerService timerService;
    @Inject
    private UpdateInstaller installer;

    protected UpdateClient updateClient() {
        return new UpdateClient(this.updateServiceBaseUri());
    }

    private URI updateServiceBaseUri() {
        return URI.create(SystemProperties.resolve((String)this.updateServiceBaseString));
    }

    protected UpdateInstaller updateInstaller() {
        return this.installer;
    }

    @PostConstruct
    private void init() {
        UpdateManagerBean.wrap(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                UpdateManagerBean.this.initConnection();
                UpdateManagerBean.this.initTimer();
                return null;
            }
        });
    }

    private void initConnection() throws JMSException {
        this.connection = this.connectionFactory.createConnection();
    }

    private void initTimer() {
        logger.log(Level.CONFIG, "The configured update interval is {0} minutes.", this.checkUpdatesIntervalMinutes);
        long intervalMillis = (long)this.checkUpdatesIntervalMinutes * 60L * 1000L;
        this.timerService.createTimer(intervalMillis, intervalMillis, null);
    }

    @PreDestroy
    private void preDestroy() {
        UpdateManagerBean.wrap(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                try {
                    UpdateManagerBean.this.shutdown();
                }
                finally {
                    UpdateManagerBean.this.closeConnection();
                }
                return null;
            }
        });
    }

    private void closeConnection() throws JMSException {
        this.connection.close();
    }

    @Nullable
    private static <V> V wrap(Callable<V> task) {
        try {
            return task.call();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }

    @Timeout
    protected void checkUpdates() throws Exception {
        super.checkUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UpdateMessage send(UpdateMessage message) throws Exception {
        Session s = this.connection.createSession(false, 1);
        try {
            ObjectMessage m = s.createObjectMessage((Serializable)message);
            m.setBooleanProperty("manager", message.type().forManager());
            s.createProducer(this.destination).send((Message)m);
        }
        finally {
            s.close();
        }
        return message;
    }
}

