/*
 * Decompiled with CFR 0.152.
 */
package net.kfoundation.java.serialization;

import java.util.List;
import java.util.Optional;
import net.kfoundation.java.serialization.ObjectDeserializer;
import net.kfoundation.java.serialization.ObjectSerializer;
import net.kfoundation.java.serialization.ValueReader;
import net.kfoundation.java.serialization.ValueWriter;

public interface ValueReadWriter<T>
extends ValueReader<T>,
ValueWriter<T> {
    default public ValueReadWriter<List<T>> toListReadWriter() {
        return new ValueReadWriter<List<T>>(){

            @Override
            public List<T> read(ObjectDeserializer objectDeserializer) {
                return ValueReadWriter.this.readList(objectDeserializer);
            }

            @Override
            public void write(ObjectSerializer objectSerializer, List<T> list) {
                ValueReadWriter.this.writeList(objectSerializer, list);
            }
        };
    }

    default public ValueReadWriter<Optional<T>> toOptionalReadWriter() {
        return new ValueReadWriter<Optional<T>>(){

            @Override
            public Optional<T> read(ObjectDeserializer objectDeserializer) {
                return Optional.of(ValueReadWriter.this.read(objectDeserializer));
            }

            @Override
            public void write(ObjectSerializer objectSerializer, Optional<T> optional) {
                optional.ifPresent(object -> ValueReadWriter.this.write(objectSerializer, object));
            }
        };
    }
}

