/*
 * Decompiled with CFR 0.152.
 */
package net.kfoundation.java.serialization;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kfoundation.java.UString;
import net.kfoundation.java.serialization.Creator;
import net.kfoundation.java.serialization.DeserializationError;
import net.kfoundation.java.serialization.ObjectDeserializer;
import net.kfoundation.java.serialization.ObjectSerializer;
import net.kfoundation.java.serialization.SerializedName;
import net.kfoundation.java.serialization.ValueReadWriter;
import net.kfoundation.java.serialization.ValueReader;

public class ValueReadWriters {
    public static ValueReadWriter<Boolean> BOOLEAN = new ValueReadWriter<Boolean>(){

        @Override
        public Boolean read(ObjectDeserializer objectDeserializer) {
            return objectDeserializer.readBooleanLiteral();
        }

        @Override
        public void write(ObjectSerializer objectSerializer, Boolean bl) {
            objectSerializer.writeLiteral(bl);
        }
    };
    public static ValueReadWriter<Integer> INT = new ValueReadWriter<Integer>(){

        @Override
        public Integer read(ObjectDeserializer objectDeserializer) {
            return (int)objectDeserializer.readIntegerLiteral();
        }

        @Override
        public void write(ObjectSerializer objectSerializer, Integer n) {
            objectSerializer.writeLiteral(n.intValue());
        }
    };
    public static ValueReadWriter<Long> LONG = new ValueReadWriter<Long>(){

        @Override
        public Long read(ObjectDeserializer objectDeserializer) {
            return objectDeserializer.readIntegerLiteral();
        }

        @Override
        public void write(ObjectSerializer objectSerializer, Long l) {
            objectSerializer.writeLiteral(l);
        }
    };
    public static ValueReadWriter<Float> FLOAT = new ValueReadWriter<Float>(){

        @Override
        public Float read(ObjectDeserializer objectDeserializer) {
            return Float.valueOf((float)objectDeserializer.readDecimalLiteral());
        }

        @Override
        public void write(ObjectSerializer objectSerializer, Float f) {
            objectSerializer.writeLiteral(f.floatValue());
        }
    };
    public static ValueReadWriter<Double> DOUBLE = new ValueReadWriter<Double>(){

        @Override
        public Double read(ObjectDeserializer objectDeserializer) {
            return objectDeserializer.readDecimalLiteral();
        }

        @Override
        public void write(ObjectSerializer objectSerializer, Double d) {
            objectSerializer.writeLiteral(d);
        }
    };
    public static ValueReadWriter<UString> USTRING = new ValueReadWriter<UString>(){

        @Override
        public UString read(ObjectDeserializer objectDeserializer) {
            return objectDeserializer.readStringLiteral();
        }

        @Override
        public void write(ObjectSerializer objectSerializer, UString uString) {
            objectSerializer.writeLiteral(uString);
        }
    };
    public static ValueReadWriter<String> STRING = new ValueReadWriter<String>(){

        @Override
        public String read(ObjectDeserializer objectDeserializer) {
            return objectDeserializer.readStringLiteral().toString();
        }

        @Override
        public void write(ObjectSerializer objectSerializer, String string) {
            objectSerializer.writeLiteral(UString.of(string));
        }
    };
    private static final Map<Class<?>, ValueReader<?>> READERS = new HashMap();

    private static <T> Optional<Constructor<T>> getCreator(Class<T> clazz) {
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getDeclaredAnnotation(Creator.class) == null) continue;
            return Optional.of(constructor);
        }
        return Optional.empty();
    }

    private static Map<Parameter, ValueReader<?>> getCreatorDefinedFields(Constructor<?> constructor) {
        return Stream.of(constructor.getParameters()).collect(Collectors.toMap(parameter -> parameter, parameter -> ValueReadWriters.getReader(parameter.getType())));
    }

    private static Map<Field, ValueReader<?>> getObjectDefinedFields(Class<?> clazz) {
        return Stream.of(clazz.getFields()).collect(Collectors.toMap(field -> field, field -> ValueReadWriters.getReader(field.getType())));
    }

    private static String getPropertyName(Parameter parameter) {
        SerializedName serializedName = parameter.getAnnotation(SerializedName.class);
        if (serializedName != null) {
            return serializedName.value();
        }
        return parameter.getName();
    }

    private static String getPropertyName(Field field) {
        SerializedName serializedName = field.getAnnotation(SerializedName.class);
        if (serializedName != null) {
            return serializedName.value();
        }
        return field.getName();
    }

    private static String getTypeName(Class<?> clazz) {
        SerializedName serializedName = clazz.getAnnotation(SerializedName.class);
        if (serializedName != null) {
            return serializedName.value();
        }
        return clazz.getSimpleName();
    }

    private static ValueReader<?> getReader(Class<?> clazz) {
        if (READERS.containsKey(clazz)) {
            return READERS.get(clazz);
        }
        for (Field field : clazz.getDeclaredFields()) {
            Class<?> clazz2;
            if (!Modifier.isStatic(field.getModifiers()) || !ValueReader.class.isAssignableFrom(clazz2 = field.getType())) continue;
            try {
                clazz2.getMethod("read", clazz);
                ValueReader valueReader = (ValueReader)field.get(null);
                READERS.put(clazz, valueReader);
                return valueReader;
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw new DeserializationError("Error finding reader for " + clazz.getName() + ": " + reflectiveOperationException.getMessage(), reflectiveOperationException);
            }
        }
        throw new DeserializationError("Could not find reader for " + clazz.getCanonicalName());
    }

    public <T> ValueReader<T> readerOf(Class<T> clazz) {
        Optional<Constructor<T>> optional = ValueReadWriters.getCreator(clazz);
        if (optional.isPresent()) {
            Constructor<T> constructor = optional.get();
            return new AutoReaderByConstructor<T>(constructor, ValueReadWriters.getCreatorDefinedFields(constructor));
        }
        return new AutoReaderByFields<T>(clazz, ValueReadWriters.getObjectDefinedFields(clazz));
    }

    private ValueReadWriters() {
    }

    static {
        READERS.put(Boolean.class, BOOLEAN);
        READERS.put(Boolean.TYPE, BOOLEAN);
        READERS.put(Integer.class, INT);
        READERS.put(Integer.TYPE, INT);
        READERS.put(Long.class, LONG);
        READERS.put(Long.TYPE, LONG);
        READERS.put(Float.class, FLOAT);
        READERS.put(Float.TYPE, FLOAT);
        READERS.put(Double.class, DOUBLE);
        READERS.put(Double.TYPE, DOUBLE);
        READERS.put(String.class, STRING);
        READERS.put(UString.class, USTRING);
    }

    private static class AutoReaderByConstructor<T>
    implements ValueReader<T> {
        private final Constructor<T> constructor;
        private final List<UString> params;
        private final ObjectReader reader;

        public AutoReaderByConstructor(Constructor<T> constructor, Map<Parameter, ValueReader<?>> map) {
            Map<UString, ValueReader<?>> map2 = map.entrySet().stream().collect(Collectors.toMap(entry -> UString.of(ValueReadWriters.getPropertyName((Parameter)entry.getKey())), Map.Entry::getValue));
            this.reader = new ObjectReader(UString.of(ValueReadWriters.getTypeName(constructor.getDeclaringClass())), map2);
            this.params = Arrays.stream(constructor.getParameters()).map(parameter -> UString.of(parameter.getName())).collect(Collectors.toList());
            this.constructor = constructor;
        }

        @Override
        public T read(ObjectDeserializer objectDeserializer) {
            Object object = this.reader.read(objectDeserializer);
            try {
                return this.constructor.newInstance(this.params.stream().map(((Map)object)::get).toArray());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                throw new DeserializationError("Error instantiating deserialized object: " + reflectiveOperationException.getMessage());
            }
        }

        @Override
        public T getDefaultValue() {
            return null;
        }
    }

    private static class AutoReaderByFields<T>
    implements ValueReader<T> {
        private final Class<T> cls;
        private final ObjectReader reader;
        private final Map<UString, Field> fieldByName;

        public AutoReaderByFields(Class<T> clazz, Map<Field, ValueReader<?>> map) {
            this.cls = clazz;
            this.fieldByName = map.entrySet().stream().collect(Collectors.toMap(entry -> UString.of(ValueReadWriters.getPropertyName((Field)entry.getKey())), Map.Entry::getKey));
            Map<UString, ValueReader<?>> map2 = map.entrySet().stream().collect(Collectors.toMap(entry -> UString.of(ValueReadWriters.getPropertyName((Field)entry.getKey())), Map.Entry::getValue));
            this.reader = new ObjectReader(UString.of(ValueReadWriters.getTypeName(clazz)), map2);
        }

        @Override
        public T read(ObjectDeserializer objectDeserializer) {
            T t;
            Object object = this.reader.read(objectDeserializer);
            try {
                t = this.cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                throw new DeserializationError("Error instantiating " + this.cls.getCanonicalName() + " for deserialization: " + reflectiveOperationException);
            }
            object.forEach((uString, object2) -> {
                Field field = this.fieldByName.get(uString);
                try {
                    field.set(t, object2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new DeserializationError("Error assigning field " + this.cls.getCanonicalName() + "." + field.getName() + ": " + illegalAccessException);
                }
            });
            return t;
        }
    }

    private static class ObjectReader
    implements ValueReader<Map<UString, Object>> {
        private final UString typeName;
        private final Map<UString, ValueReader<?>> fieldMap;

        public ObjectReader(UString uString, Map<UString, ValueReader<?>> map) {
            this.typeName = uString;
            this.fieldMap = map;
        }

        @Override
        public Map<UString, Object> read(ObjectDeserializer objectDeserializer) {
            objectDeserializer.readObjectBegin().ifPresent(uString -> {
                if (!uString.equals(this.typeName)) {
                    throw new DeserializationError("Trying to read object of type " + this.typeName + " but found: " + uString);
                }
            });
            HashMap<UString, Object> hashMap = new HashMap<UString, Object>();
            Optional<UString> optional = objectDeserializer.tryReadPropertyName();
            while (optional.isPresent()) {
                UString uString2 = optional.get();
                ValueReader<?> valueReader = this.fieldMap.get(uString2);
                if (valueReader == null) {
                    throw new DeserializationError("Found unexpected field in input while reading object of type " + this.typeName + ": " + uString2);
                }
                hashMap.put(uString2, valueReader.read(objectDeserializer));
                optional = objectDeserializer.tryReadPropertyName();
            }
            objectDeserializer.readObjectEnd();
            return hashMap;
        }
    }
}

