/*
 * Decompiled with CFR 0.152.
 */
package net.kfoundation.java.serialization;

import java.util.List;
import java.util.Optional;
import net.kfoundation.java.serialization.ObjectSerializer;

public interface ValueWriter<T> {
    public void write(ObjectSerializer var1, T var2);

    default public void writeList(ObjectSerializer objectSerializer, List<T> list) {
        objectSerializer.writeCollectionBegin();
        for (T t : list) {
            this.write(objectSerializer, t);
        }
        objectSerializer.writeCollectionEnd();
    }

    default public void writeOptional(ObjectSerializer objectSerializer, Optional<T> optional) {
        optional.ifPresent(object -> this.write(objectSerializer, object));
    }

    default public ValueWriter<List<T>> toListWriter() {
        return this::writeList;
    }

    default public ValueWriter<Optional<T>> toOptionalWriter() {
        return this::writeOptional;
    }
}

