/*
 * Decompiled with CFR 0.152.
 */
package net.kfoundation.java.serialization;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.kfoundation.java.serialization.DeserializationError;
import net.kfoundation.java.serialization.ObjectDeserializer;

public interface ValueReader<T> {
    public T read(ObjectDeserializer var1);

    default public T getDefaultValue() {
        throw new DeserializationError("Value is missing and no default is available");
    }

    default public List<T> readList(ObjectDeserializer objectDeserializer) {
        LinkedList<T> linkedList = new LinkedList<T>();
        objectDeserializer.readCollectionBegin();
        while (!objectDeserializer.tryReadCollectionEnd()) {
            linkedList.add(this.read(objectDeserializer));
        }
        return linkedList;
    }

    default public ValueReader<List<T>> toListReader() {
        return this::readList;
    }

    default public ValueReader<Optional<T>> toOptionalReader() {
        return new ValueReader<Optional<T>>(){

            @Override
            public Optional<T> read(ObjectDeserializer objectDeserializer) {
                return Optional.of(ValueReader.this.read(objectDeserializer));
            }

            @Override
            public Optional<T> getDefaultValue() {
                return Optional.empty();
            }
        };
    }
}

