package net.lightapi.portal.instance.command.handler;

import com.networknt.rpc.router.ServiceHandler;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Unlock an instance for the host for mutation
 */
@ServiceHandler(id="lightapi.net/instance/unlockInstance/0.1.0")
public class UnlockInstance extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(UnlockInstance.class);

    @Override
    protected String getCloudEventType() {
        return PortalConstants.INSTANCE_UNLOCKED_EVENT;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
