/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.instance.command.handler;

import com.networknt.config.JsonMapper;
import com.networknt.db.provider.DbProvider;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.UuidUtil;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.impl.BaseCloudEventBuilder;
import io.undertow.server.HttpServerExchange;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.lightapi.portal.EventTypeUtil;
import net.lightapi.portal.PortalConstants;
import net.lightapi.portal.command.AbstractCommandHandler;
import net.lightapi.portal.db.PortalDbProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/instance/compositeCreateInstanceApp/0.1.0")
public class CompositeCreateInstanceApp
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CompositeCreateInstanceApp.class);
    public static PortalDbProvider dbProvider = (PortalDbProvider)SingletonServiceFactory.getBean(DbProvider.class);

    protected String getCloudEventType() {
        return "CompositeInstanceAppCreatedEvent";
    }

    protected Logger getLogger() {
        return logger;
    }

    protected String getCloudEventAggregateId(Map<String, Object> map) {
        return (String)map.get("instanceAppId");
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String appId = (String)map.get("appId");
        String hostId = (String)map.get("hostId");
        String instanceId = (String)map.get("instanceId");
        String appVersion = (String)map.get("appVersion");
        map.put("instanceAppId", CompositeCreateInstanceApp.getInstanceAppId(hostId, instanceId, appId, appVersion));
        return Success.of(map);
    }

    protected CloudEvent[] buildCloudEvent(Map<String, Object> map, String userId, String host, Number nonce) {
        ArrayList<CloudEvent> events = new ArrayList<CloudEvent>();
        HashMap<String, Object> appData = new HashMap<String, Object>(map);
        appData.put("eventType", "AppCreatedEvent");
        appData.put("appId", map.get("appId"));
        CloudEvent appEvent = this.buildCloudEventApp(appData, userId, host);
        events.add(appEvent);
        HashMap<String, Object> instanceAppData = new HashMap<String, Object>(map);
        instanceAppData.put("eventType", "InstanceAppCreatedEvent");
        CloudEvent instanceAppEvent = this.buildCloudEventInstanceApp(instanceAppData, userId, host);
        events.add(instanceAppEvent);
        return events.toArray(new CloudEvent[0]);
    }

    private CloudEvent buildCloudEventApp(Map<String, Object> map, String userId, String host) {
        String aggregateType = "App";
        String appId = (String)map.get("appId");
        String eventType = (String)map.get("eventType");
        if (appId == null || appId.isEmpty()) {
            throw new IllegalArgumentException("appId is missing or empty in the provided data");
        }
        HashMap<String, String> appAggregateMap = new HashMap<String, String>();
        String hostId = (String)map.get("hostId");
        appAggregateMap.put("appId", appId);
        appAggregateMap.put("hostId", hostId);
        String aggregateId = EventTypeUtil.getAggregateId((String)eventType, appAggregateMap);
        int maxAggregateVersion = dbProvider.getMaxAggregateVersion(aggregateId);
        int newAggregateVersion = maxAggregateVersion + 1;
        BaseCloudEventBuilder eventBuilder = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withSource(PortalConstants.EVENT_SOURCE).withType(eventType).withId(UuidUtil.getUUID().toString()).withTime(OffsetDateTime.now()).withSubject(aggregateId).withExtension("user", userId)).withExtension("nonce", (Number)dbProvider.queryNonceByUserId(userId))).withExtension("host", host)).withExtension("aggregatetype", aggregateType)).withExtension("aggregateversion", Integer.valueOf(newAggregateVersion));
        String data = JsonMapper.toJson(map);
        eventBuilder.withData("application/json", data.getBytes(StandardCharsets.UTF_8));
        if (logger.isTraceEnabled()) {
            logger.trace("Creating App event: user = {}, host = {}, type = {}, data = {}", new Object[]{userId, host, eventType, data});
        }
        return eventBuilder.build();
    }

    private CloudEvent buildCloudEventInstanceApp(Map<String, Object> map, String userId, String host) {
        String aggregateType = "InstanceApp";
        String instanceAppId = (String)map.get("instanceAppId");
        String eventType = (String)map.get("eventType");
        if (instanceAppId == null || instanceAppId.isEmpty()) {
            throw new IllegalArgumentException("instanceAppId is missing or empty in the provided data");
        }
        HashMap<String, String> instanceAppAggMap = new HashMap<String, String>();
        instanceAppAggMap.put("instanceAppId", instanceAppId);
        String aggregateId = EventTypeUtil.getAggregateId((String)eventType, instanceAppAggMap);
        BaseCloudEventBuilder eventBuilder = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withSource(PortalConstants.EVENT_SOURCE).withType(eventType).withId(UuidUtil.getUUID().toString()).withTime(OffsetDateTime.now()).withSubject(aggregateId).withExtension("user", userId)).withExtension("nonce", (Number)dbProvider.queryNonceByUserId(userId))).withExtension("host", host)).withExtension("aggregatetype", aggregateType)).withExtension("aggregateversion", (Number)map.get("newAggregateVersion"));
        String data = JsonMapper.toJson(map);
        eventBuilder.withData("application/json", data.getBytes(StandardCharsets.UTF_8));
        if (logger.isTraceEnabled()) {
            logger.trace("Creating Instance App event: user = {}, host = {}, type = {}, data = {}", new Object[]{userId, host, eventType, data});
        }
        return eventBuilder.build();
    }

    private static String getInstanceAppId(String hostId, String instanceId, String appId, String appVersion) {
        String instanceAppId = dbProvider.getInstanceAppId(hostId, instanceId, appId, appVersion);
        if (instanceAppId != null && !instanceAppId.isEmpty()) {
            return instanceAppId;
        }
        return UuidUtil.getUUID().toString();
    }
}

