/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.instance.command.handler;

import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/instance/createInstance/0.1.0")
public class CreateInstance
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateInstance.class);

    protected String getCloudEventType() {
        return "InstanceCreatedEvent";
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String productVersionId;
        String envTag;
        String serviceId;
        String hostId = (String)map.get("hostId");
        String instanceId = dbProvider.getInstanceId(hostId, serviceId = (String)map.get("serviceId"), envTag = (String)map.get("envTag"), productVersionId = (String)map.get("productVersionId"));
        if (instanceId != null) {
            map.put("instanceId", instanceId);
        } else {
            map.put("instanceId", UuidUtil.getUUID().toString());
        }
        return Success.of(map);
    }
}

