/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.instance.command.handler;

import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.UuidUtil;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import net.lightapi.portal.command.AbstractCommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/instance/createInstanceApi/0.1.0")
public class CreateInstanceApi
extends AbstractCommandHandler {
    private static final Logger logger = LoggerFactory.getLogger(CreateInstanceApi.class);

    protected String getCloudEventType() {
        return "InstanceApiCreatedEvent";
    }

    protected Logger getLogger() {
        return logger;
    }

    protected Result<Map<String, Object>> enrichInput(HttpServerExchange exchange, Map<String, Object> map) {
        String apiVersionId;
        String instanceId;
        String hostId = (String)map.get("hostId");
        String instanceApiId = dbProvider.getInstanceApiId(hostId, instanceId = (String)map.get("instanceId"), apiVersionId = (String)map.get("apiVersionId"));
        if (instanceApiId != null) {
            map.put("instanceApiId", instanceApiId);
        } else {
            map.put("instanceApiId", UuidUtil.getUUID().toString());
        }
        return Success.of(map);
    }
}

