/*
 * Decompiled with CFR 0.152.
 */
package net.lightapi.portal.covid.command.handler;

import com.networknt.config.Config;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.kafka.common.AvroSerializer;
import com.networknt.kafka.common.EventId;
import com.networknt.monad.Result;
import com.networknt.rpc.HybridHandler;
import com.networknt.rpc.router.ServiceHandler;
import com.networknt.utility.NioUtils;
import io.undertow.server.HttpServerExchange;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import net.lightapi.portal.HybridQueryClient;
import net.lightapi.portal.PortalConfig;
import net.lightapi.portal.command.HybridCommandStartup;
import net.lightapi.portal.covid.CovidStatusDeletedEvent;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceHandler(id="lightapi.net/covid/deleteStatus/0.1.0")
public class DeleteStatus
implements HybridHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeleteStatus.class);
    private static final PortalConfig config = (PortalConfig)Config.getInstance().getJsonObjectConfig("portal", PortalConfig.class);
    private static final String SEND_MESSAGE_EXCEPTION = "ERR11605";
    AvroSerializer serializer = new AvroSerializer();

    public ByteBuffer handle(HttpServerExchange exchange, Object input) {
        if (logger.isTraceEnabled()) {
            logger.trace("input = " + String.valueOf(input));
        }
        Map auditInfo = (Map)exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        String userId = (String)auditInfo.get("user_id");
        Map map = (Map)input;
        String hostId = (String)map.get("hostId");
        Result resultNonce = HybridQueryClient.getNonceByUserId((HttpServerExchange)exchange, (String)userId);
        if (resultNonce.isSuccess()) {
            EventId eventId = EventId.newBuilder().setId(userId).setNonce(Long.valueOf((String)resultNonce.getResult()).longValue()).setTimestamp(System.currentTimeMillis()).build();
            CovidStatusDeletedEvent event = CovidStatusDeletedEvent.newBuilder().setEventId(eventId).setHostId(hostId).setUserId(userId).build();
            byte[] bytes = this.serializer.serialize((Object)event);
            ProducerRecord record = new ProducerRecord(config.getTopic(), (Object)(config.isMultitenancy() ? hostId : userId).getBytes(StandardCharsets.UTF_8), (Object)bytes);
            CountDownLatch latch = new CountDownLatch(1);
            try {
                HybridCommandStartup.producer.send(record, (recordMetadata, e) -> {
                    if (Objects.nonNull(e)) {
                        logger.error("Exception occurred while pushing the event", (Throwable)e);
                    } else {
                        logger.info("Event record pushed successfully. Received Record Metadata is {}", (Object)recordMetadata);
                    }
                    latch.countDown();
                });
                latch.await();
            }
            catch (InterruptedException e2) {
                logger.error("Exception:", (Throwable)e2);
                return NioUtils.toByteBuffer((String)this.getStatus(exchange, SEND_MESSAGE_EXCEPTION, new Object[]{e2.getMessage(), config.isMultitenancy() ? hostId : userId}));
            }
        } else {
            return NioUtils.toByteBuffer((String)this.getStatus(exchange, resultNonce.getError()));
        }
        return NioUtils.toByteBuffer((String)this.getStatus(exchange, "SUC10200", new Object[0]));
    }
}

