/**
 * Copyright (c) 2012-present 铭软科技(mingsoft.net)
 * 本软件及相关文档文件（以下简称“软件”）的版权归 铭软科技 所有
 * 遵循 铭软科技《服务协议》中的《保密条款》
 */

package net.mingsoft.basic.annotation;


import jakarta.validation.Constraint;
import jakarta.validation.Payload;
import net.mingsoft.basic.validator.XssValidator;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Constraint(validatedBy = { XssValidator.class })
public @interface Xss {
    String message() default "Xss验证失败，内容不合法";
    Class<?>[] groups() default {};
    Class<? extends Payload>[] payload() default {};
}
