/**
 * Copyright (c) 2012-present 铭软科技(mingsoft.net)
 * 本软件及相关文档文件（以下简称“软件”）的版权归 铭软科技 所有
 * 遵循 铭软科技《服务协议》中的《保密条款》
 */

package net.mingsoft.basic.validator;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import net.mingsoft.basic.annotation.Xss;
import net.mingsoft.basic.util.JsoupUtil;

public class XssValidator implements ConstraintValidator<Xss, String> {
    @Override
    public boolean isValid(String fieldValue, ConstraintValidatorContext constraintValidatorContext) {
        if (fieldValue == null) {
            return true;
        }
        return !JsoupUtil.hasXSS(fieldValue);
    }
}
