/*
 * Decompiled with CFR 0.152.
 */
package net.mst.utilities.timer;

import net.mst.utilities.timer.Task;
import net.mst.utilities.timer.TimerThread;
import net.mst.utilities.timer.TimerUnit;

public class Timer {
    private TimerThread thread;
    private boolean highPrecision = false;

    public Timer() {
    }

    public Timer(boolean enableHighPrecision) {
        this.highPrecision = true;
    }

    public Timer schedule(Task Task2, long Interval) {
        Task2.setTimer(this);
        this.thread = new TimerThread(Interval, Task2, this.highPrecision);
        this.thread.start();
        return this;
    }

    public Timer schedule(Task Task2, long Interval, TimerUnit TimeUnit) {
        Task2.setTimer(this);
        this.thread = new TimerThread(TimeUnit.getMilliseconds(Interval), Task2, this.highPrecision);
        this.thread.start();
        return this;
    }

    public Timer setInterval(Long Interval) {
        this.thread.setInterval(Interval, -1);
        return this;
    }

    public Timer setTempInterval(Long Interval, Integer Rotations) {
        this.thread.setInterval(Interval, Rotations);
        return this;
    }

    public void cancel() {
        this.thread.cancel();
    }

    public Timer setTask(Task Task2) {
        this.thread.setTask(Task2);
        return this;
    }

    public Timer pause() {
        this.thread.setPaused(true);
        return this;
    }

    public Timer resume() {
        this.thread.setPaused(false);
        return this;
    }
}

