/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.common;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import net.quedex.api.common.CommunicationException;
import net.quedex.api.common.MaintenanceException;
import net.quedex.api.market.StreamFailureListener;
import net.quedex.api.pgp.PGPExceptionBase;
import org.slf4j.Logger;

public abstract class MessageReceiver {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String KEEPALIVE_STR = "keepalive";
    private final Logger logger;
    private volatile StreamFailureListener streamFailureListener;

    protected MessageReceiver(Logger logger) {
        this.logger = (Logger)Preconditions.checkNotNull((Object)logger, (Object)"null logger");
    }

    protected abstract void processData(String var1) throws IOException, PGPExceptionBase;

    public final void processMessage(String message) {
        if (KEEPALIVE_STR.equals(message)) {
            this.logger.trace(KEEPALIVE_STR);
            return;
        }
        try {
            JsonNode metaJson = OBJECT_MAPPER.readTree(message);
            switch (metaJson.get("type").asText()) {
                case "data": {
                    this.processData(metaJson.get("data").asText());
                    break;
                }
                case "error": {
                    this.processError(metaJson.get("error_code").asText());
                    break;
                }
            }
        }
        catch (IOException e) {
            this.onError(new CommunicationException("Error parsing json entity on message=" + message, e));
        }
        catch (PGPExceptionBase e) {
            this.onError(new CommunicationException("PGP error on message=" + message, e));
        }
    }

    private void processError(String errorCode) {
        this.logger.trace("processError({})", (Object)errorCode);
        if ("maintenance".equals(errorCode)) {
            this.onError(new MaintenanceException());
        }
    }

    private void onError(Exception e) {
        this.logger.warn("onError({})", (Throwable)e);
        StreamFailureListener streamFailureListener = this.streamFailureListener;
        if (streamFailureListener != null) {
            streamFailureListener.onStreamFailure(e);
        }
    }

    public final void registerStreamFailureListener(StreamFailureListener streamFailureListener) {
        this.streamFailureListener = streamFailureListener;
    }
}

