/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.market;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.quedex.api.common.CommunicationException;
import net.quedex.api.common.Config;
import net.quedex.api.common.MessageReceiver;
import net.quedex.api.market.Instrument;
import net.quedex.api.market.MarketData;
import net.quedex.api.pgp.BcPublicKey;
import net.quedex.api.pgp.BcSignatureVerifier;
import net.quedex.api.pgp.PGPExceptionBase;

public class HttpMarketData
implements MarketData {
    private static final ObjectMapper OBJECT_MAPPER = MessageReceiver.OBJECT_MAPPER;
    private final String instrumentDataUrl;
    private final BcSignatureVerifier signatureVerifier;

    public HttpMarketData(String instrumentDataUrl, BcPublicKey publicKey) {
        Preconditions.checkArgument((!instrumentDataUrl.isEmpty() ? 1 : 0) != 0, (Object)"Empty instrumentDataUrl");
        this.instrumentDataUrl = instrumentDataUrl;
        this.signatureVerifier = new BcSignatureVerifier(publicKey);
    }

    public HttpMarketData(Config config) {
        this(config.getInstrumentDataUrl(), config.getQdxPublicKey());
    }

    @Override
    public Map<Integer, Instrument> getInstruments() throws CommunicationException {
        try {
            String data = (String)Unirest.get((String)this.instrumentDataUrl).asString().getBody();
            JsonNode metaJson = OBJECT_MAPPER.readTree(this.signatureVerifier.verifySignature(data));
            return (Map)OBJECT_MAPPER.treeToValue((TreeNode)metaJson.get("data"), InstrumentsMap.class);
        }
        catch (UnirestException | IOException | PGPExceptionBase e) {
            throw new CommunicationException("Error fetching instruments", e);
        }
    }

    static {
        Unirest.setTimeouts((long)10000L, (long)10000L);
    }

    private static class InstrumentsMap
    extends HashMap<Integer, Instrument> {
        private InstrumentsMap() {
        }
    }
}

