/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.market;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;
import net.quedex.api.market.PriceQuantity;

public class OrderBook {
    private final int instrumentId;
    private final List<PriceQuantity> bids;
    private final List<PriceQuantity> asks;

    @JsonCreator
    public OrderBook(@JsonProperty(value="instrument_id") int instrumentId, @JsonProperty(value="bids") List<PriceQuantity> bids, @JsonProperty(value="asks") List<PriceQuantity> asks) {
        this.instrumentId = instrumentId;
        this.bids = (List)Preconditions.checkNotNull(bids, (Object)"null bids");
        this.asks = (List)Preconditions.checkNotNull(asks, (Object)"null asks");
    }

    public int getInstrumentId() {
        return this.instrumentId;
    }

    public List<PriceQuantity> getBids() {
        return this.bids;
    }

    public List<PriceQuantity> getAsks() {
        return this.asks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderBook orderBook = (OrderBook)o;
        return this.instrumentId == orderBook.instrumentId && Objects.equal(this.bids, orderBook.bids) && Objects.equal(this.asks, orderBook.asks);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.instrumentId, this.bids, this.asks});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("instrumentId", this.instrumentId).add("bids", this.bids).add("asks", this.asks).toString();
    }
}

