/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.pgp;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.quedex.api.pgp.BcPublicKey;
import net.quedex.api.pgp.PGPKeyInitialisationException;
import net.quedex.api.pgp.PGPKeyNotFoundException;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;

public final class BcPrivateKey {
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private final PGPSecretKey secretKey;
    private final PGPPrivateKey privateKey;
    private final String fingerprint;
    private final ImmutableMap<Long, PGPPrivateKey> privateKeys;
    private final BcPublicKey publicKey;

    public static BcPrivateKey fromArmored(String armoredKeyString) throws PGPKeyInitialisationException {
        return BcPrivateKey.fromArmored(armoredKeyString, EMPTY_CHAR_ARRAY);
    }

    public static BcPrivateKey fromArmored(String armoredKeyString, char[] passphrase) throws PGPKeyInitialisationException {
        return new BcPrivateKey(armoredKeyString, passphrase);
    }

    BcPrivateKey(String armoredKeyString, char[] passphrase) throws PGPKeyInitialisationException {
        try {
            PGPSecretKeyRing secKeyRing = new PGPSecretKeyRing((InputStream)new ArmoredInputStream((InputStream)new ByteArrayInputStream(armoredKeyString.getBytes(StandardCharsets.US_ASCII))), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            PBESecretKeyDecryptor decryptor = new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(passphrase);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ArrayList<PGPPublicKey> pubKeys = new ArrayList<PGPPublicKey>(2);
            Iterator iterator = secKeyRing.getSecretKeys();
            while (iterator.hasNext()) {
                PGPSecretKey secretKey = (PGPSecretKey)iterator.next();
                PGPPrivateKey privateKey = secretKey.extractPrivateKey(decryptor);
                builder.put((Object)privateKey.getKeyID(), (Object)privateKey);
                pubKeys.add(secretKey.getPublicKey());
            }
            this.secretKey = secKeyRing.getSecretKey();
            this.privateKeys = builder.build();
            this.privateKey = this.secretKey.extractPrivateKey(decryptor);
            this.publicKey = pubKeys.size() >= 2 ? new BcPublicKey((PGPPublicKey)pubKeys.get(0), (PGPPublicKey)pubKeys.get(1)) : new BcPublicKey((PGPPublicKey)pubKeys.get(0), (PGPPublicKey)pubKeys.get(0));
        }
        catch (IOException | RuntimeException | PGPException e) {
            throw new PGPKeyInitialisationException("Error instantiating a private key", e);
        }
        Preconditions.checkNotNull((Object)this.secretKey);
        Preconditions.checkNotNull((Object)this.privateKey);
        this.fingerprint = BcPublicKey.hexFingerprint(this.secretKey.getPublicKey());
    }

    PGPSecretKey getSecretKey() {
        return this.secretKey;
    }

    PGPPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    PGPPrivateKey getPrivateKeyWithId(long keyId) throws PGPKeyNotFoundException {
        if (!this.privateKeys.containsKey((Object)keyId)) {
            throw new PGPKeyNotFoundException(String.format("Key with id: %s not found", Long.toHexString(keyId).toUpperCase()));
        }
        return (PGPPrivateKey)this.privateKeys.get((Object)keyId);
    }

    public Collection<PGPPrivateKey> getPrivateKeys() {
        return this.privateKeys.values();
    }

    public BcPublicKey getPublicKey() {
        return this.publicKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        BcPrivateKey that = (BcPrivateKey)o;
        return Objects.equal((Object)this.fingerprint, (Object)that.fingerprint);
    }

    public int hashCode() {
        return this.fingerprint.hashCode();
    }
}

