/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.pgp;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import net.quedex.api.pgp.PGPKeyInitialisationException;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;

public final class BcPublicKey {
    private final PGPPublicKey signingKey;
    private final PGPPublicKey encryptionKey;
    private final String fingerprint;
    private final String mainKeyIdentity;

    public static BcPublicKey fromArmored(String armoredKeyString) throws PGPKeyInitialisationException {
        try {
            PGPPublicKeyRing pubKeyRing = new PGPPublicKeyRing((InputStream)new ArmoredInputStream((InputStream)new ByteArrayInputStream(armoredKeyString.getBytes(StandardCharsets.UTF_8))), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            if (Iterators.size((Iterator)pubKeyRing.getPublicKeys()) < 1) {
                throw new PGPKeyInitialisationException("No keys in keyring");
            }
            PGPPublicKey signingKey = pubKeyRing.getPublicKey();
            ArrayList keys = Lists.newArrayList((Iterator)pubKeyRing.getPublicKeys());
            PGPPublicKey encryptionKey = keys.size() == 1 ? signingKey : (PGPPublicKey)keys.get(1);
            if (!encryptionKey.isEncryptionKey()) {
                throw new PGPKeyInitialisationException("Error instatiating public key: sign-only key.");
            }
            return new BcPublicKey(signingKey, encryptionKey);
        }
        catch (IOException | RuntimeException e) {
            throw new PGPKeyInitialisationException("Error instantiating a public key", e);
        }
    }

    BcPublicKey(PGPPublicKey signingKey, PGPPublicKey encryptionKey) {
        this.signingKey = signingKey;
        this.encryptionKey = encryptionKey;
        this.fingerprint = BcPublicKey.hexFingerprint(signingKey);
        this.mainKeyIdentity = (String)signingKey.getUserIDs().next();
    }

    PGPPublicKey getSigningKey() {
        return this.signingKey;
    }

    PGPPublicKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getMainKeyIdentity() {
        return this.mainKeyIdentity;
    }

    public String armored() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArmoredOutputStream armored = new ArmoredOutputStream((OutputStream)out);
        try {
            this.signingKey.encode((OutputStream)armored);
            this.encryptionKey.encode((OutputStream)armored);
            armored.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error writing armored public key", e);
        }
        return new String(out.toByteArray(), StandardCharsets.US_ASCII);
    }

    static String hexFingerprint(PGPPublicKey publicKey) {
        byte[] bytes = publicKey.getFingerprint();
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        BcPublicKey that = (BcPublicKey)o;
        return this.fingerprint.equals(that.fingerprint);
    }

    public int hashCode() {
        return this.fingerprint.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fingerprint", (Object)this.fingerprint).toString();
    }
}

