/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth;

import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.RetryHandler;
import net.lenni0451.commons.httpclient.constants.ContentTypes;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.BiMergeStep;
import net.raphimc.minecraftauth.step.bedrock.StepMCChain;
import net.raphimc.minecraftauth.step.bedrock.StepPlayFabToken;
import net.raphimc.minecraftauth.step.bedrock.session.StepFullBedrockSession;
import net.raphimc.minecraftauth.step.edu.StepEduJWT;
import net.raphimc.minecraftauth.step.java.StepMCProfile;
import net.raphimc.minecraftauth.step.java.StepMCToken;
import net.raphimc.minecraftauth.step.java.StepPlayerCertificates;
import net.raphimc.minecraftauth.step.java.session.StepFullJavaSession;
import net.raphimc.minecraftauth.step.msa.MsaCodeStep;
import net.raphimc.minecraftauth.step.msa.StepCredentialsMsaCode;
import net.raphimc.minecraftauth.step.msa.StepJfxWebViewMsaCode;
import net.raphimc.minecraftauth.step.msa.StepLocalWebServer;
import net.raphimc.minecraftauth.step.msa.StepLocalWebServerMsaCode;
import net.raphimc.minecraftauth.step.msa.StepMsaDeviceCode;
import net.raphimc.minecraftauth.step.msa.StepMsaDeviceCodeMsaCode;
import net.raphimc.minecraftauth.step.msa.StepMsaToken;
import net.raphimc.minecraftauth.step.xbl.StepXblDeviceToken;
import net.raphimc.minecraftauth.step.xbl.StepXblSisuAuthentication;
import net.raphimc.minecraftauth.step.xbl.StepXblTitleToken;
import net.raphimc.minecraftauth.step.xbl.StepXblUserToken;
import net.raphimc.minecraftauth.step.xbl.StepXblXstsToken;
import net.raphimc.minecraftauth.step.xbl.adapter.StepXblXstsToFullXblSession;
import net.raphimc.minecraftauth.step.xbl.session.StepFullXblSession;
import net.raphimc.minecraftauth.step.xbl.session.StepInitialXblSession;
import net.raphimc.minecraftauth.util.OAuthEnvironment;
import net.raphimc.minecraftauth.util.logging.ConsoleLogger;
import net.raphimc.minecraftauth.util.logging.ILogger;
import org.jetbrains.annotations.ApiStatus;

public class MinecraftAuth {
    public static final String VERSION = "4.0.1";
    public static final String IMPL_VERSION = "git-MinecraftAuth-4.0.1:bb2ec21";
    public static ILogger LOGGER = new ConsoleLogger();
    public static String USER_AGENT = "MinecraftAuth/4.0.1";
    public static final AbstractStep<?, StepFullJavaSession.FullJavaSession> JAVA_DEVICE_CODE_LOGIN = MinecraftAuth.builder().withClientId("00000000402b5328").withScope("service::user.auth.xboxlive.com::MBI_SSL").deviceCode().withDeviceToken("Win32").sisuTitleAuthentication("rp://api.minecraftservices.com/").buildMinecraftJavaProfileStep(true);
    @ApiStatus.Experimental
    public static final AbstractStep<?, StepFullJavaSession.FullJavaSession> ALT_JAVA_DEVICE_CODE_LOGIN = MinecraftAuth.builder().withClientId("00000000402b5328").withScope("service::user.auth.xboxlive.com::MBI_SSL").deviceCode().withoutDeviceToken().regularAuthentication("rp://api.minecraftservices.com/").buildMinecraftJavaProfileStep(true);
    public static final AbstractStep<?, StepFullJavaSession.FullJavaSession> JAVA_CREDENTIALS_LOGIN = MinecraftAuth.builder().withClientId("00000000402b5328").withScope("service::user.auth.xboxlive.com::MBI_SSL").credentials().withDeviceToken("Win32").sisuTitleAuthentication("rp://api.minecraftservices.com/").buildMinecraftJavaProfileStep(true);
    @ApiStatus.Experimental
    public static final AbstractStep<?, StepFullJavaSession.FullJavaSession> ALT_JAVA_CREDENTIALS_LOGIN = MinecraftAuth.builder().withClientId("00000000402b5328").withScope("service::user.auth.xboxlive.com::MBI_SSL").credentials().withoutDeviceToken().regularAuthentication("rp://api.minecraftservices.com/").buildMinecraftJavaProfileStep(true);
    public static final AbstractStep<?, StepFullBedrockSession.FullBedrockSession> BEDROCK_DEVICE_CODE_LOGIN = MinecraftAuth.builder().withClientId("0000000048183522").withScope("service::user.auth.xboxlive.com::MBI_SSL").deviceCode().withDeviceToken("Android").sisuTitleAuthentication("https://multiplayer.minecraft.net/").buildMinecraftBedrockChainStep(true, false);
    public static final AbstractStep<?, StepFullBedrockSession.FullBedrockSession> BEDROCK_CREDENTIALS_LOGIN = MinecraftAuth.builder().withClientId("0000000048183522").withScope("service::user.auth.xboxlive.com::MBI_SSL").credentials().withDeviceToken("Android").sisuTitleAuthentication("https://multiplayer.minecraft.net/").buildMinecraftBedrockChainStep(true, false);
    @ApiStatus.Experimental
    public static final AbstractStep<?, StepEduJWT.EduJWT> EDU_DEVICE_CODE_LOGIN = new StepEduJWT(InitialXblSessionBuilder.access$000(MinecraftAuth.builder().withClientId("b36b1432-1a1c-4c82-9b76-24de1cab42f2").withScope("https://meeservices.minecraft.net/.default offline_access").withOAuthEnvironment(OAuthEnvironment.MICROSOFT_ONLINE_COMMON).deviceCode()), "1.20.80", 671, "Windows Desktop Build (Win32)(x64)");

    public static MsaTokenBuilder builder() {
        return new MsaTokenBuilder();
    }

    public static HttpClient createHttpClient() {
        int timeout = 5000;
        return (HttpClient)((HttpClient)((HttpClient)new HttpClient().setConnectTimeout(5000).setReadTimeout(10000).setCookieManager(null).setFollowRedirects(false).setRetryHandler(new RetryHandler(0, 50)).setHeader("Accept", ContentTypes.APPLICATION_JSON.toString())).setHeader("Accept-Language", "en-US,en")).setHeader("User-Agent", USER_AGENT);
    }

    public static class MinecraftBuilder {
        private final AbstractStep<?, ? extends StepXblXstsToken.XblXsts<?>> xblXstsTokenStep;

        private MinecraftBuilder(XblXstsTokenBuilder parent) {
            this.xblXstsTokenStep = parent.build();
        }

        public StepFullJavaSession buildMinecraftJavaProfileStep(boolean playerCertificates) {
            StepMCToken mcTokenStep = new StepMCToken(this.xblXstsTokenStep);
            StepPlayerCertificates playerCertificatesStep = playerCertificates ? new StepPlayerCertificates(mcTokenStep) : null;
            return new StepFullJavaSession(new StepMCProfile(mcTokenStep), playerCertificatesStep);
        }

        public StepFullBedrockSession buildMinecraftBedrockChainStep(boolean playFabToken, boolean realmsXsts) {
            StepPlayFabToken playFabTokenStep = new StepPlayFabToken(new StepXblXstsToken(new StepXblXstsToFullXblSession(this.xblXstsTokenStep), "https://b980a380.minecraft.playfabapi.com/"));
            StepXblXstsToken realmsXstsStep = new StepXblXstsToken("realmsXsts", new StepXblXstsToFullXblSession(this.xblXstsTokenStep), "https://pocket.realms.minecraft.net/");
            return new StepFullBedrockSession(new StepMCChain(this.xblXstsTokenStep), playFabToken ? playFabTokenStep : null, realmsXsts ? realmsXstsStep : null);
        }
    }

    public static class XblXstsTokenBuilder {
        private final BiMergeStep<StepMsaToken.MsaToken, StepXblDeviceToken.XblDeviceToken, StepInitialXblSession.InitialXblSession> initialXblSessionStep;
        private AbstractStep<?, ? extends StepXblXstsToken.XblXsts<?>> xblXstsTokenStep;

        private XblXstsTokenBuilder(InitialXblSessionBuilder parent) {
            this.initialXblSessionStep = parent.build();
        }

        public MinecraftBuilder sisuTitleAuthentication(String relyingParty) {
            this.xblXstsTokenStep = new StepXblSisuAuthentication(this.initialXblSessionStep, relyingParty);
            return new MinecraftBuilder(this);
        }

        public MinecraftBuilder titleAuthentication(String relyingParty) {
            this.xblXstsTokenStep = new StepXblXstsToken(new StepFullXblSession(new StepXblUserToken(this.initialXblSessionStep), new StepXblTitleToken(this.initialXblSessionStep)), relyingParty);
            return new MinecraftBuilder(this);
        }

        public MinecraftBuilder regularAuthentication(String relyingParty) {
            this.xblXstsTokenStep = new StepXblXstsToken(new StepFullXblSession(new StepXblUserToken(this.initialXblSessionStep), null), relyingParty);
            return new MinecraftBuilder(this);
        }

        public AbstractStep<?, ? extends StepXblXstsToken.XblXsts<?>> build() {
            return this.xblXstsTokenStep;
        }
    }

    public static class InitialXblSessionBuilder {
        private final AbstractStep<MsaCodeStep.MsaCode, StepMsaToken.MsaToken> msaTokenStep;
        private BiMergeStep<StepMsaToken.MsaToken, StepXblDeviceToken.XblDeviceToken, StepInitialXblSession.InitialXblSession> initialXblSessionStep;

        private InitialXblSessionBuilder(MsaTokenBuilder parent) {
            this.msaTokenStep = parent.build();
        }

        public XblXstsTokenBuilder withDeviceToken(String deviceType) {
            this.initialXblSessionStep = new StepInitialXblSession(this.msaTokenStep, new StepXblDeviceToken(deviceType));
            return new XblXstsTokenBuilder(this);
        }

        public XblXstsTokenBuilder withoutDeviceToken() {
            this.initialXblSessionStep = new StepInitialXblSession(this.msaTokenStep, null);
            return new XblXstsTokenBuilder(this);
        }

        public BiMergeStep<StepMsaToken.MsaToken, StepXblDeviceToken.XblDeviceToken, StepInitialXblSession.InitialXblSession> build() {
            return this.initialXblSessionStep;
        }

        static /* synthetic */ AbstractStep access$000(InitialXblSessionBuilder x0) {
            return x0.msaTokenStep;
        }
    }

    public static class MsaTokenBuilder {
        private MsaCodeStep.ApplicationDetails applicationDetails = new MsaCodeStep.ApplicationDetails("00000000402b5328", "XboxLive.signin XboxLive.offline_access", null, null, OAuthEnvironment.LIVE);
        private int timeout = 120;
        private AbstractStep<?, MsaCodeStep.MsaCode> msaCodeStep;

        public MsaTokenBuilder withClientId(String clientId) {
            this.applicationDetails = this.applicationDetails.withClientId(clientId);
            return this;
        }

        public MsaTokenBuilder withScope(String scope) {
            this.applicationDetails = this.applicationDetails.withScope(scope);
            return this;
        }

        public MsaTokenBuilder withClientSecret(String clientSecret) {
            this.applicationDetails = this.applicationDetails.withClientSecret(clientSecret);
            return this;
        }

        public MsaTokenBuilder withRedirectUri(String redirectUri) {
            this.applicationDetails = this.applicationDetails.withRedirectUri(redirectUri);
            return this;
        }

        public MsaTokenBuilder withOAuthEnvironment(OAuthEnvironment oAuthEnvironment) {
            this.applicationDetails = this.applicationDetails.withOAuthEnvironment(oAuthEnvironment);
            return this;
        }

        public MsaTokenBuilder withTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public InitialXblSessionBuilder deviceCode() {
            this.msaCodeStep = new StepMsaDeviceCodeMsaCode(new StepMsaDeviceCode(this.applicationDetails), this.timeout * 1000);
            return new InitialXblSessionBuilder(this);
        }

        public InitialXblSessionBuilder credentials() {
            if (this.applicationDetails.getRedirectUri() == null) {
                this.applicationDetails = this.applicationDetails.withRedirectUri(this.applicationDetails.getOAuthEnvironment().getNativeClientUrl());
            }
            this.msaCodeStep = new StepCredentialsMsaCode(this.applicationDetails);
            return new InitialXblSessionBuilder(this);
        }

        public InitialXblSessionBuilder javaFxWebView() {
            if (this.applicationDetails.getRedirectUri() == null) {
                this.applicationDetails = this.applicationDetails.withRedirectUri(this.applicationDetails.getOAuthEnvironment().getNativeClientUrl());
            }
            this.msaCodeStep = new StepJfxWebViewMsaCode(this.applicationDetails, this.timeout * 1000);
            return new InitialXblSessionBuilder(this);
        }

        public InitialXblSessionBuilder localWebServer() {
            if (this.applicationDetails.getRedirectUri() == null) {
                this.applicationDetails = this.applicationDetails.withRedirectUri("http://localhost");
            }
            this.msaCodeStep = new StepLocalWebServerMsaCode(new StepLocalWebServer(this.applicationDetails), this.timeout * 1000);
            return new InitialXblSessionBuilder(this);
        }

        public InitialXblSessionBuilder customMsaCodeStep(AbstractStep<?, MsaCodeStep.MsaCode> msaCodeStep) {
            this.msaCodeStep = msaCodeStep;
            return new InitialXblSessionBuilder(this);
        }

        public AbstractStep<MsaCodeStep.MsaCode, StepMsaToken.MsaToken> build() {
            return new StepMsaToken(this.msaCodeStep);
        }
    }
}

