/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.msa;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.util.JsonUtil;
import net.raphimc.minecraftauth.util.OAuthEnvironment;
import net.raphimc.minecraftauth.util.UuidUtil;

public abstract class MsaCodeStep<I extends AbstractStep.StepResult<?>>
extends AbstractStep<I, MsaCode> {
    public MsaCodeStep(AbstractStep<?, I> prevStep) {
        super("msaCode", prevStep);
    }

    @Override
    public MsaCode fromJson(JsonObject json) {
        return new MsaCode(json.get("code").getAsString(), new ApplicationDetails(json.get("clientId").getAsString(), json.get("scope").getAsString(), JsonUtil.getStringOr(json, "clientSecret", null), JsonUtil.getStringOr(json, "redirectUri", null), OAuthEnvironment.valueOf(JsonUtil.getStringOr(json, "oAuthEnvironment", "LIVE"))));
    }

    @Override
    public JsonObject toJson(MsaCode msaCode) {
        JsonObject json = new JsonObject();
        json.addProperty("code", msaCode.code);
        json.addProperty("clientId", msaCode.applicationDetails.clientId);
        json.addProperty("scope", msaCode.applicationDetails.scope);
        json.addProperty("clientSecret", msaCode.applicationDetails.clientSecret);
        json.addProperty("redirectUri", msaCode.applicationDetails.redirectUri);
        json.addProperty("oAuthEnvironment", msaCode.applicationDetails.oAuthEnvironment.name());
        return json;
    }

    public static final class MsaCode
    extends AbstractStep.StepResult<ApplicationDetails> {
        private final String code;
        private final ApplicationDetails applicationDetails;

        @Override
        protected ApplicationDetails prevResult() {
            return this.applicationDetails;
        }

        public MsaCode(String code, ApplicationDetails applicationDetails) {
            this.code = code;
            this.applicationDetails = applicationDetails;
        }

        public String getCode() {
            return this.code;
        }

        public ApplicationDetails getApplicationDetails() {
            return this.applicationDetails;
        }

        public String toString() {
            return "MsaCodeStep.MsaCode(code=" + this.getCode() + ", applicationDetails=" + this.getApplicationDetails() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MsaCode)) {
                return false;
            }
            MsaCode other = (MsaCode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            ApplicationDetails this$applicationDetails = this.getApplicationDetails();
            ApplicationDetails other$applicationDetails = other.getApplicationDetails();
            return !(this$applicationDetails == null ? other$applicationDetails != null : !((Object)this$applicationDetails).equals(other$applicationDetails));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MsaCode;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            ApplicationDetails $applicationDetails = this.getApplicationDetails();
            result = result * 59 + ($applicationDetails == null ? 43 : ((Object)$applicationDetails).hashCode());
            return result;
        }
    }

    public static final class ApplicationDetails
    extends AbstractStep.FirstStepResult {
        private final String clientId;
        private final String scope;
        private final String clientSecret;
        private final String redirectUri;
        private final OAuthEnvironment oAuthEnvironment;

        public boolean isTitleClientId() {
            return !UuidUtil.isDashedUuid(this.clientId);
        }

        public Map<String, String> getOAuthParameters() {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("client_id", this.clientId);
            parameters.put("scope", this.scope);
            parameters.put("redirect_uri", this.redirectUri);
            parameters.put("response_type", "code");
            parameters.put("response_mode", "query");
            return parameters;
        }

        public ApplicationDetails(String clientId, String scope, String clientSecret, String redirectUri, OAuthEnvironment oAuthEnvironment) {
            this.clientId = clientId;
            this.scope = scope;
            this.clientSecret = clientSecret;
            this.redirectUri = redirectUri;
            this.oAuthEnvironment = oAuthEnvironment;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getScope() {
            return this.scope;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public String getRedirectUri() {
            return this.redirectUri;
        }

        public OAuthEnvironment getOAuthEnvironment() {
            return this.oAuthEnvironment;
        }

        public String toString() {
            return "MsaCodeStep.ApplicationDetails(clientId=" + this.getClientId() + ", scope=" + this.getScope() + ", clientSecret=" + this.getClientSecret() + ", redirectUri=" + this.getRedirectUri() + ", oAuthEnvironment=" + (Object)((Object)this.getOAuthEnvironment()) + ")";
        }

        public ApplicationDetails withClientId(String clientId) {
            return this.clientId == clientId ? this : new ApplicationDetails(clientId, this.scope, this.clientSecret, this.redirectUri, this.oAuthEnvironment);
        }

        public ApplicationDetails withScope(String scope) {
            return this.scope == scope ? this : new ApplicationDetails(this.clientId, scope, this.clientSecret, this.redirectUri, this.oAuthEnvironment);
        }

        public ApplicationDetails withClientSecret(String clientSecret) {
            return this.clientSecret == clientSecret ? this : new ApplicationDetails(this.clientId, this.scope, clientSecret, this.redirectUri, this.oAuthEnvironment);
        }

        public ApplicationDetails withRedirectUri(String redirectUri) {
            return this.redirectUri == redirectUri ? this : new ApplicationDetails(this.clientId, this.scope, this.clientSecret, redirectUri, this.oAuthEnvironment);
        }

        public ApplicationDetails withOAuthEnvironment(OAuthEnvironment oAuthEnvironment) {
            return this.oAuthEnvironment == oAuthEnvironment ? this : new ApplicationDetails(this.clientId, this.scope, this.clientSecret, this.redirectUri, oAuthEnvironment);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplicationDetails)) {
                return false;
            }
            ApplicationDetails other = (ApplicationDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                return false;
            }
            String this$scope = this.getScope();
            String other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            String this$clientSecret = this.getClientSecret();
            String other$clientSecret = other.getClientSecret();
            if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
                return false;
            }
            String this$redirectUri = this.getRedirectUri();
            String other$redirectUri = other.getRedirectUri();
            if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
                return false;
            }
            OAuthEnvironment this$oAuthEnvironment = this.getOAuthEnvironment();
            OAuthEnvironment other$oAuthEnvironment = other.getOAuthEnvironment();
            return !(this$oAuthEnvironment == null ? other$oAuthEnvironment != null : !((Object)((Object)this$oAuthEnvironment)).equals((Object)other$oAuthEnvironment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ApplicationDetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            String $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            String $clientSecret = this.getClientSecret();
            result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
            String $redirectUri = this.getRedirectUri();
            result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
            OAuthEnvironment $oAuthEnvironment = this.getOAuthEnvironment();
            result = result * 59 + ($oAuthEnvironment == null ? 43 : ((Object)((Object)$oAuthEnvironment)).hashCode());
            return result;
        }
    }
}

