/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.msa;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.CookieManager;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.constants.ContentTypes;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.content.impl.URLEncodedFormContent;
import net.lenni0451.commons.httpclient.exceptions.HttpRequestException;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.requests.impl.GetRequest;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.lenni0451.commons.httpclient.utils.URLWrapper;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.responsehandler.exception.InformativeHttpRequestException;
import net.raphimc.minecraftauth.responsehandler.exception.MsaRequestException;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.msa.MsaCodeStep;
import net.raphimc.minecraftauth.util.JsonUtil;

public class StepCredentialsMsaCode
extends MsaCodeStep<MsaCredentials> {
    private final MsaCodeStep.ApplicationDetails applicationDetails;

    public StepCredentialsMsaCode(MsaCodeStep.ApplicationDetails applicationDetails) {
        super(null);
        this.applicationDetails = applicationDetails;
    }

    @Override
    public MsaCodeStep.MsaCode applyStep(HttpClient httpClient, MsaCredentials msaCredentials) throws Exception {
        String urlPost;
        MinecraftAuth.LOGGER.info("Trying to get MSA Code using email and password...");
        if (msaCredentials == null) {
            throw new IllegalStateException("Missing StepCredentialsMsaCode.MsaCredentials input");
        }
        CookieManager cookieManager = new CookieManager();
        URL authenticationUrl = new URLWrapper(this.applicationDetails.getOAuthEnvironment().getAuthorizeUrl()).wrapQuery().addQueries(this.applicationDetails.getOAuthParameters()).apply().toURL();
        GetRequest getRequest = new GetRequest(authenticationUrl);
        getRequest.setCookieManager(cookieManager);
        getRequest.setHeader("Accept", ContentTypes.TEXT_HTML.getMimeType());
        JsonObject config = (JsonObject)httpClient.execute((HttpRequest)getRequest, response -> {
            if (response.getStatusCode() >= 300) {
                Map parameters;
                Optional locationHeader = response.getFirstHeader("Location");
                if (locationHeader.isPresent() && (parameters = new URLWrapper((String)locationHeader.get()).wrapQuery().getQueries()).containsKey("error") && parameters.containsKey("error_description")) {
                    throw new MsaRequestException(response, (String)parameters.get("error"), (String)parameters.get("error_description"));
                }
                throw new HttpRequestException(response);
            }
            return this.extractConfig(response.getContentAsString());
        });
        HashMap<String, String> postData = new HashMap<String, String>();
        switch (this.applicationDetails.getOAuthEnvironment()) {
            case LIVE: {
                urlPost = config.get("urlPost").getAsString();
                String sFTTag = config.get("sFTTag").getAsString();
                String sFT = sFTTag.substring(sFTTag.indexOf("value=\"") + 7);
                sFT = sFT.substring(0, sFT.indexOf("\""));
                String sFTName = sFTTag.substring(sFTTag.indexOf("name=\"") + 6);
                sFTName = sFTName.substring(0, sFTName.indexOf("\""));
                postData.put("login", msaCredentials.email);
                postData.put("loginfmt", msaCredentials.email);
                postData.put("passwd", msaCredentials.password);
                postData.put(sFTName, sFT);
                break;
            }
            case MICROSOFT_ONLINE_COMMON: 
            case MICROSOFT_ONLINE_CONSUMERS: {
                urlPost = config.get("urlPost").getAsString();
                urlPost = new URLWrapper(urlPost).setProtocol(authenticationUrl.getProtocol()).setHost(authenticationUrl.getHost()).toURL().toString();
                String sFT = config.get("sFT").getAsString();
                String sFTName = config.get("sFTName").getAsString();
                String sCtx = config.get("sCtx").getAsString();
                postData.put("login", msaCredentials.email);
                postData.put("loginfmt", msaCredentials.email);
                postData.put("passwd", msaCredentials.password);
                postData.put("ctx", sCtx);
                postData.put(sFTName, sFT);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported OAuthEnvironment: " + (Object)((Object)this.applicationDetails.getOAuthEnvironment()));
            }
        }
        PostRequest postRequest = new PostRequest(urlPost);
        postRequest.setCookieManager(cookieManager);
        postRequest.setHeader("Accept", ContentTypes.TEXT_HTML.getMimeType());
        postRequest.setContent((HttpContent)new URLEncodedFormContent(postData));
        String code = (String)httpClient.execute((HttpRequest)postRequest, response -> {
            Optional locationHeader;
            if (response.getStatusCode() != 302) {
                if (!response.getContentType().orElse(ContentTypes.TEXT_PLAIN).getMimeType().equals(ContentTypes.TEXT_HTML.getMimeType())) {
                    throw new InformativeHttpRequestException(response, "Wrong content type");
                }
                JsonObject errorConfig = this.extractConfig(response.getContentAsString());
                switch (this.applicationDetails.getOAuthEnvironment()) {
                    case LIVE: {
                        if (!errorConfig.has("sErrorCode") || !errorConfig.has("sErrTxt")) break;
                        throw new MsaRequestException(response, errorConfig.get("sErrorCode").getAsString(), errorConfig.get("sErrTxt").getAsString());
                    }
                    case MICROSOFT_ONLINE_COMMON: 
                    case MICROSOFT_ONLINE_CONSUMERS: {
                        if (!errorConfig.has("iErrorCode") || !errorConfig.has("strServiceExceptionMessage")) break;
                        throw new MsaRequestException(response, errorConfig.get("iErrorCode").getAsString(), errorConfig.get("strServiceExceptionMessage").getAsString());
                    }
                    default: {
                        throw new IllegalStateException("Unsupported OAuthEnvironment: " + (Object)((Object)this.applicationDetails.getOAuthEnvironment()));
                    }
                }
            }
            if (!(locationHeader = response.getFirstHeader("Location")).isPresent()) {
                throw new IllegalStateException("Could not get redirect url");
            }
            Map parameters = new URLWrapper((String)locationHeader.get()).wrapQuery().getQueries();
            if (!parameters.containsKey("code")) {
                throw new IllegalStateException("Could not extract MSA Code from redirect url");
            }
            return (String)parameters.get("code");
        });
        MsaCodeStep.MsaCode msaCode = new MsaCodeStep.MsaCode(code, this.applicationDetails);
        MinecraftAuth.LOGGER.info("Got MSA Code");
        return msaCode;
    }

    private JsonObject extractConfig(String html) {
        switch (this.applicationDetails.getOAuthEnvironment()) {
            case LIVE: {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(html.substring(html.indexOf("var ServerData = ") + 17)));
                jsonReader.setLenient(true);
                return (JsonObject)JsonUtil.GSON.fromJson(jsonReader, JsonObject.class);
            }
            case MICROSOFT_ONLINE_COMMON: 
            case MICROSOFT_ONLINE_CONSUMERS: {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(html.substring(html.indexOf("$Config=") + 8)));
                jsonReader.setLenient(true);
                return (JsonObject)JsonUtil.GSON.fromJson(jsonReader, JsonObject.class);
            }
        }
        throw new IllegalStateException("Unsupported OAuthEnvironment: " + (Object)((Object)this.applicationDetails.getOAuthEnvironment()));
    }

    public static final class MsaCredentials
    extends AbstractStep.InitialInput {
        private final String email;
        private final String password;

        public static MsaCredentials fromJson(JsonObject json) {
            return new MsaCredentials(json.get("email").getAsString(), json.get("password").getAsString());
        }

        public static JsonObject toJson(MsaCredentials msaCredentials) {
            JsonObject json = new JsonObject();
            json.addProperty("email", msaCredentials.email);
            json.addProperty("password", msaCredentials.password);
            return json;
        }

        public MsaCredentials(String email, String password) {
            this.email = email;
            this.password = password;
        }

        public String getEmail() {
            return this.email;
        }

        public String getPassword() {
            return this.password;
        }

        public String toString() {
            return "StepCredentialsMsaCode.MsaCredentials(email=" + this.getEmail() + ", password=" + this.getPassword() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MsaCredentials)) {
                return false;
            }
            MsaCredentials other = (MsaCredentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MsaCredentials;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }
    }
}

