/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.msa;

import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebView;
import javax.swing.JFrame;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.utils.URLWrapper;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.responsehandler.exception.MsaRequestException;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.msa.MsaCodeStep;

public class StepJfxWebViewMsaCode
extends MsaCodeStep<JavaFxWebView> {
    private final MsaCodeStep.ApplicationDetails applicationDetails;
    private final int timeout;

    public StepJfxWebViewMsaCode(MsaCodeStep.ApplicationDetails applicationDetails, int timeout) {
        super(null);
        this.applicationDetails = applicationDetails;
        this.timeout = timeout;
    }

    @Override
    public MsaCodeStep.MsaCode applyStep(HttpClient httpClient, JavaFxWebView javaFxWebViewCallback) throws Exception {
        MinecraftAuth.LOGGER.info("Opening JavaFX WebView window for MSA login...");
        JFXPanel jfxPanel = new JFXPanel();
        URL authenticationUrl = new URLWrapper(this.applicationDetails.getOAuthEnvironment().getAuthorizeUrl()).wrapQuery().addQueries(this.applicationDetails.getOAuthParameters()).apply().toURL();
        final CompletableFuture msaCodeFuture = new CompletableFuture();
        JFrame window = new JFrame("MinecraftAuth - Microsoft Login");
        window.setDefaultCloseOperation(0);
        window.setSize(800, 600);
        window.setLocationRelativeTo(null);
        window.setResizable(false);
        window.setContentPane((Container)jfxPanel);
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!msaCodeFuture.isDone()) {
                    msaCodeFuture.completeExceptionally(new UserClosedWindowException());
                }
            }
        });
        Platform.runLater(() -> {
            WebView webView = new WebView();
            webView.setContextMenuEnabled(false);
            webView.getEngine().setUserAgent(MinecraftAuth.USER_AGENT);
            webView.getEngine().load(authenticationUrl.toString());
            webView.getEngine().locationProperty().addListener((observable, oldValue, newValue) -> {
                try {
                    if (newValue.startsWith(this.applicationDetails.getRedirectUri())) {
                        Map parameters = new URLWrapper(newValue).wrapQuery().getQueries();
                        if (parameters.containsKey("error") && parameters.containsKey("error_description")) {
                            HttpResponse fakeResponse = new HttpResponse(null, 500, new byte[0], Collections.emptyMap());
                            throw new MsaRequestException(fakeResponse, (String)parameters.get("error"), (String)parameters.get("error_description"));
                        }
                        if (!parameters.containsKey("code")) {
                            throw new IllegalStateException("Could not extract MSA Code from response url");
                        }
                        msaCodeFuture.complete(new MsaCodeStep.MsaCode((String)parameters.get("code"), this.applicationDetails));
                    }
                }
                catch (Throwable e) {
                    msaCodeFuture.completeExceptionally(e);
                }
            });
            jfxPanel.setScene(new Scene((Parent)webView, (double)window.getWidth(), (double)window.getHeight()));
            if (javaFxWebViewCallback == null) {
                window.setVisible(true);
            } else {
                javaFxWebViewCallback.openCallback.accept(window, webView);
            }
        });
        try {
            MsaCodeStep.MsaCode msaCode = (MsaCodeStep.MsaCode)msaCodeFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            window.dispose();
            MinecraftAuth.LOGGER.info("Got MSA Code");
            return msaCode;
        }
        catch (TimeoutException e) {
            window.dispose();
            throw new TimeoutException("MSA login timed out");
        }
        catch (ExecutionException e) {
            window.dispose();
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    public static class UserClosedWindowException
    extends Exception {
        public UserClosedWindowException() {
            super("User closed login window");
        }
    }

    public static final class JavaFxWebView
    extends AbstractStep.InitialInput {
        private final BiConsumer<JFrame, WebView> openCallback = (window, webView) -> window.setVisible(true);

        public BiConsumer<JFrame, WebView> getOpenCallback() {
            return this.openCallback;
        }

        public String toString() {
            return "StepJfxWebViewMsaCode.JavaFxWebView(openCallback=" + this.getOpenCallback() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JavaFxWebView)) {
                return false;
            }
            JavaFxWebView other = (JavaFxWebView)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BiConsumer<JFrame, WebView> this$openCallback = this.getOpenCallback();
            BiConsumer<JFrame, WebView> other$openCallback = other.getOpenCallback();
            return !(this$openCallback == null ? other$openCallback != null : !this$openCallback.equals(other$openCallback));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JavaFxWebView;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BiConsumer<JFrame, WebView> $openCallback = this.getOpenCallback();
            result = result * 59 + ($openCallback == null ? 43 : $openCallback.hashCode());
            return result;
        }
    }
}

