/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.msa;

import com.google.gson.JsonObject;
import java.net.ServerSocket;
import java.net.URL;
import java.util.function.Consumer;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.utils.URLWrapper;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.msa.MsaCodeStep;

public class StepLocalWebServer
extends AbstractStep<LocalWebServerCallback, LocalWebServer> {
    private final MsaCodeStep.ApplicationDetails applicationDetails;

    public StepLocalWebServer(MsaCodeStep.ApplicationDetails applicationDetails) {
        super("localWebServer", null);
        if (applicationDetails.getRedirectUri().endsWith("/")) {
            throw new IllegalArgumentException("Redirect URI must not end with a slash");
        }
        this.applicationDetails = applicationDetails;
    }

    @Override
    public LocalWebServer applyStep(HttpClient httpClient, LocalWebServerCallback localWebServerCallback) throws Exception {
        MinecraftAuth.LOGGER.info("Creating URL for MSA login via local webserver...");
        if (localWebServerCallback == null) {
            throw new IllegalStateException("Missing StepLocalWebServer.LocalWebServerCallback input");
        }
        try (ServerSocket localServer = new ServerSocket(0);){
            int localPort = localServer.getLocalPort();
            URL authenticationUrl = new URLWrapper(this.applicationDetails.getOAuthEnvironment().getAuthorizeUrl()).wrapQuery().addQueries(this.applicationDetails.getOAuthParameters()).setQuery("redirect_uri", this.applicationDetails.getRedirectUri() + ":" + localPort).setQuery("prompt", "select_account").apply().toURL();
            LocalWebServer localWebServer = new LocalWebServer(authenticationUrl.toString(), localPort, this.applicationDetails);
            MinecraftAuth.LOGGER.info("Created local webserver MSA authentication URL: " + localWebServer.getAuthenticationUrl());
            localWebServerCallback.callback.accept(localWebServer);
            LocalWebServer localWebServer2 = localWebServer;
            return localWebServer2;
        }
    }

    @Override
    public LocalWebServer fromJson(JsonObject json) {
        return new LocalWebServer(json.get("authenticationUrl").getAsString(), json.get("port").getAsInt(), this.applicationDetails);
    }

    @Override
    public JsonObject toJson(LocalWebServer localWebServer) {
        JsonObject json = new JsonObject();
        json.addProperty("authenticationUrl", localWebServer.authenticationUrl);
        json.addProperty("port", (Number)localWebServer.port);
        return json;
    }

    public static final class LocalWebServerCallback
    extends AbstractStep.InitialInput {
        private final Consumer<LocalWebServer> callback;

        public LocalWebServerCallback(Consumer<LocalWebServer> callback) {
            this.callback = callback;
        }

        public Consumer<LocalWebServer> getCallback() {
            return this.callback;
        }

        public String toString() {
            return "StepLocalWebServer.LocalWebServerCallback(callback=" + this.getCallback() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalWebServerCallback)) {
                return false;
            }
            LocalWebServerCallback other = (LocalWebServerCallback)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Consumer<LocalWebServer> this$callback = this.getCallback();
            Consumer<LocalWebServer> other$callback = other.getCallback();
            return !(this$callback == null ? other$callback != null : !this$callback.equals(other$callback));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LocalWebServerCallback;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Consumer<LocalWebServer> $callback = this.getCallback();
            result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
            return result;
        }
    }

    public static final class LocalWebServer
    extends AbstractStep.StepResult<MsaCodeStep.ApplicationDetails> {
        private final String authenticationUrl;
        private final int port;
        private final MsaCodeStep.ApplicationDetails applicationDetails;

        public LocalWebServer(String authenticationUrl, int port, MsaCodeStep.ApplicationDetails applicationDetails) {
            this.authenticationUrl = authenticationUrl;
            this.port = port;
            this.applicationDetails = applicationDetails.withRedirectUri(applicationDetails.getRedirectUri() + ":" + port);
        }

        @Override
        protected MsaCodeStep.ApplicationDetails prevResult() {
            return this.applicationDetails;
        }

        public String getAuthenticationUrl() {
            return this.authenticationUrl;
        }

        public int getPort() {
            return this.port;
        }

        public MsaCodeStep.ApplicationDetails getApplicationDetails() {
            return this.applicationDetails;
        }

        public String toString() {
            return "StepLocalWebServer.LocalWebServer(authenticationUrl=" + this.getAuthenticationUrl() + ", port=" + this.getPort() + ", applicationDetails=" + this.getApplicationDetails() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalWebServer)) {
                return false;
            }
            LocalWebServer other = (LocalWebServer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$authenticationUrl = this.getAuthenticationUrl();
            String other$authenticationUrl = other.getAuthenticationUrl();
            if (this$authenticationUrl == null ? other$authenticationUrl != null : !this$authenticationUrl.equals(other$authenticationUrl)) {
                return false;
            }
            MsaCodeStep.ApplicationDetails this$applicationDetails = this.getApplicationDetails();
            MsaCodeStep.ApplicationDetails other$applicationDetails = other.getApplicationDetails();
            return !(this$applicationDetails == null ? other$applicationDetails != null : !((Object)this$applicationDetails).equals(other$applicationDetails));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LocalWebServer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            String $authenticationUrl = this.getAuthenticationUrl();
            result = result * 59 + ($authenticationUrl == null ? 43 : $authenticationUrl.hashCode());
            MsaCodeStep.ApplicationDetails $applicationDetails = this.getApplicationDetails();
            result = result * 59 + ($applicationDetails == null ? 43 : ((Object)$applicationDetails).hashCode());
            return result;
        }
    }
}

