/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.msa;

import com.google.gson.JsonObject;
import java.time.Instant;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.function.Consumer;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.content.impl.URLEncodedFormContent;
import net.lenni0451.commons.httpclient.handler.HttpResponseHandler;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.responsehandler.MsaResponseHandler;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.msa.MsaCodeStep;
import net.raphimc.minecraftauth.util.OAuthEnvironment;

public class StepMsaDeviceCode
extends AbstractStep<MsaDeviceCodeCallback, MsaDeviceCode> {
    private final MsaCodeStep.ApplicationDetails applicationDetails;

    public StepMsaDeviceCode(MsaCodeStep.ApplicationDetails applicationDetails) {
        super("msaDeviceCode", null);
        this.applicationDetails = applicationDetails;
    }

    @Override
    public MsaDeviceCode applyStep(HttpClient httpClient, MsaDeviceCodeCallback msaDeviceCodeCallback) throws Exception {
        MinecraftAuth.LOGGER.info("Getting device code for MSA login...");
        if (msaDeviceCodeCallback == null) {
            throw new IllegalStateException("Missing StepMsaDeviceCode.MsaDeviceCodeCallback input");
        }
        HashMap<String, String> postData = new HashMap<String, String>();
        postData.put("client_id", this.applicationDetails.getClientId());
        postData.put("scope", this.applicationDetails.getScope());
        if (this.applicationDetails.getOAuthEnvironment() == OAuthEnvironment.LIVE) {
            postData.put("response_type", "device_code");
        }
        PostRequest postRequest = new PostRequest(this.applicationDetails.getOAuthEnvironment().getDeviceCodeUrl());
        postRequest.setContent((HttpContent)new URLEncodedFormContent(postData));
        JsonObject obj = (JsonObject)httpClient.execute((HttpRequest)postRequest, (HttpResponseHandler)new MsaResponseHandler());
        MsaDeviceCode msaDeviceCode = new MsaDeviceCode(System.currentTimeMillis() + obj.get("expires_in").getAsLong() * 1000L, obj.get("interval").getAsLong() * 1000L, obj.get("device_code").getAsString(), obj.get("user_code").getAsString(), obj.get("verification_uri").getAsString(), this.applicationDetails);
        MinecraftAuth.LOGGER.info("Got MSA device code, expires: " + Instant.ofEpochMilli(msaDeviceCode.getExpireTimeMs()).atZone(ZoneId.systemDefault()));
        msaDeviceCodeCallback.callback.accept(msaDeviceCode);
        return msaDeviceCode;
    }

    @Override
    public MsaDeviceCode fromJson(JsonObject json) {
        return new MsaDeviceCode(json.get("expireTimeMs").getAsLong(), json.get("intervalMs").getAsLong(), json.get("deviceCode").getAsString(), json.get("userCode").getAsString(), json.get("verificationUrl").getAsString(), this.applicationDetails);
    }

    @Override
    public JsonObject toJson(MsaDeviceCode msaDeviceCode) {
        JsonObject json = new JsonObject();
        json.addProperty("expireTimeMs", (Number)msaDeviceCode.expireTimeMs);
        json.addProperty("intervalMs", (Number)msaDeviceCode.intervalMs);
        json.addProperty("deviceCode", msaDeviceCode.deviceCode);
        json.addProperty("userCode", msaDeviceCode.userCode);
        json.addProperty("verificationUrl", msaDeviceCode.verificationUri);
        return json;
    }

    public static final class MsaDeviceCodeCallback
    extends AbstractStep.InitialInput {
        private final Consumer<MsaDeviceCode> callback;

        public MsaDeviceCodeCallback(Consumer<MsaDeviceCode> callback) {
            this.callback = callback;
        }

        public Consumer<MsaDeviceCode> getCallback() {
            return this.callback;
        }

        public String toString() {
            return "StepMsaDeviceCode.MsaDeviceCodeCallback(callback=" + this.getCallback() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MsaDeviceCodeCallback)) {
                return false;
            }
            MsaDeviceCodeCallback other = (MsaDeviceCodeCallback)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Consumer<MsaDeviceCode> this$callback = this.getCallback();
            Consumer<MsaDeviceCode> other$callback = other.getCallback();
            return !(this$callback == null ? other$callback != null : !this$callback.equals(other$callback));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MsaDeviceCodeCallback;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Consumer<MsaDeviceCode> $callback = this.getCallback();
            result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
            return result;
        }
    }

    public static final class MsaDeviceCode
    extends AbstractStep.StepResult<MsaCodeStep.ApplicationDetails> {
        private final long expireTimeMs;
        private final long intervalMs;
        private final String deviceCode;
        private final String userCode;
        private final String verificationUri;
        private final MsaCodeStep.ApplicationDetails applicationDetails;

        @Override
        protected MsaCodeStep.ApplicationDetails prevResult() {
            return this.applicationDetails;
        }

        @Override
        public boolean isExpired() {
            return this.expireTimeMs <= System.currentTimeMillis();
        }

        public String getDirectVerificationUri() {
            return this.verificationUri + "?otc=" + this.userCode;
        }

        public MsaDeviceCode(long expireTimeMs, long intervalMs, String deviceCode, String userCode, String verificationUri, MsaCodeStep.ApplicationDetails applicationDetails) {
            this.expireTimeMs = expireTimeMs;
            this.intervalMs = intervalMs;
            this.deviceCode = deviceCode;
            this.userCode = userCode;
            this.verificationUri = verificationUri;
            this.applicationDetails = applicationDetails;
        }

        public long getExpireTimeMs() {
            return this.expireTimeMs;
        }

        public long getIntervalMs() {
            return this.intervalMs;
        }

        public String getDeviceCode() {
            return this.deviceCode;
        }

        public String getUserCode() {
            return this.userCode;
        }

        public String getVerificationUri() {
            return this.verificationUri;
        }

        public MsaCodeStep.ApplicationDetails getApplicationDetails() {
            return this.applicationDetails;
        }

        public String toString() {
            return "StepMsaDeviceCode.MsaDeviceCode(expireTimeMs=" + this.getExpireTimeMs() + ", intervalMs=" + this.getIntervalMs() + ", deviceCode=" + this.getDeviceCode() + ", userCode=" + this.getUserCode() + ", verificationUri=" + this.getVerificationUri() + ", applicationDetails=" + this.getApplicationDetails() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MsaDeviceCode)) {
                return false;
            }
            MsaDeviceCode other = (MsaDeviceCode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
                return false;
            }
            if (this.getIntervalMs() != other.getIntervalMs()) {
                return false;
            }
            String this$deviceCode = this.getDeviceCode();
            String other$deviceCode = other.getDeviceCode();
            if (this$deviceCode == null ? other$deviceCode != null : !this$deviceCode.equals(other$deviceCode)) {
                return false;
            }
            String this$userCode = this.getUserCode();
            String other$userCode = other.getUserCode();
            if (this$userCode == null ? other$userCode != null : !this$userCode.equals(other$userCode)) {
                return false;
            }
            String this$verificationUri = this.getVerificationUri();
            String other$verificationUri = other.getVerificationUri();
            if (this$verificationUri == null ? other$verificationUri != null : !this$verificationUri.equals(other$verificationUri)) {
                return false;
            }
            MsaCodeStep.ApplicationDetails this$applicationDetails = this.getApplicationDetails();
            MsaCodeStep.ApplicationDetails other$applicationDetails = other.getApplicationDetails();
            return !(this$applicationDetails == null ? other$applicationDetails != null : !((Object)this$applicationDetails).equals(other$applicationDetails));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MsaDeviceCode;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expireTimeMs = this.getExpireTimeMs();
            result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
            long $intervalMs = this.getIntervalMs();
            result = result * 59 + (int)($intervalMs >>> 32 ^ $intervalMs);
            String $deviceCode = this.getDeviceCode();
            result = result * 59 + ($deviceCode == null ? 43 : $deviceCode.hashCode());
            String $userCode = this.getUserCode();
            result = result * 59 + ($userCode == null ? 43 : $userCode.hashCode());
            String $verificationUri = this.getVerificationUri();
            result = result * 59 + ($verificationUri == null ? 43 : $verificationUri.hashCode());
            MsaCodeStep.ApplicationDetails $applicationDetails = this.getApplicationDetails();
            result = result * 59 + ($applicationDetails == null ? 43 : ((Object)$applicationDetails).hashCode());
            return result;
        }
    }
}

