/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.msa;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Instant;
import java.time.ZoneId;
import java.util.HashMap;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.content.impl.URLEncodedFormContent;
import net.lenni0451.commons.httpclient.handler.HttpResponseHandler;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.responsehandler.MsaResponseHandler;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.msa.MsaCodeStep;
import net.raphimc.minecraftauth.util.JsonUtil;

public class StepMsaToken
extends AbstractStep<MsaCodeStep.MsaCode, MsaToken> {
    public StepMsaToken(AbstractStep<?, MsaCodeStep.MsaCode> prevStep) {
        super("msaToken", prevStep);
    }

    @Override
    public MsaToken applyStep(HttpClient httpClient, MsaCodeStep.MsaCode msaCode) throws Exception {
        return this.apply(httpClient, msaCode.getCode(), msaCode.getApplicationDetails().getRedirectUri() != null ? "authorization_code" : "refresh_token", msaCode);
    }

    @Override
    public MsaToken refresh(HttpClient httpClient, MsaToken msaToken) throws Exception {
        if (!msaToken.isExpired()) {
            return msaToken;
        }
        if (msaToken.getRefreshToken() != null) {
            return this.apply(httpClient, msaToken.getRefreshToken(), "refresh_token", msaToken.getMsaCode());
        }
        return super.refresh(httpClient, msaToken);
    }

    @Override
    public MsaToken fromJson(JsonObject json) {
        MsaCodeStep.MsaCode msaCode = this.prevStep != null ? (MsaCodeStep.MsaCode)this.prevStep.fromJson(json.getAsJsonObject(this.prevStep.name)) : null;
        return new MsaToken(json.get("expireTimeMs").getAsLong(), json.get("accessToken").getAsString(), JsonUtil.getStringOr(json, "refreshToken", null), JsonUtil.getStringOr(json, "idToken", null), msaCode);
    }

    @Override
    public JsonObject toJson(MsaToken msaToken) {
        JsonObject json = new JsonObject();
        json.addProperty("expireTimeMs", (Number)msaToken.expireTimeMs);
        json.addProperty("accessToken", msaToken.accessToken);
        json.addProperty("refreshToken", msaToken.refreshToken);
        json.addProperty("idToken", msaToken.idToken);
        if (this.prevStep != null) {
            json.add(this.prevStep.name, (JsonElement)this.prevStep.toJson(msaToken.msaCode));
        }
        return json;
    }

    private MsaToken apply(HttpClient httpClient, String code, String type, MsaCodeStep.MsaCode msaCode) throws Exception {
        MsaCodeStep.ApplicationDetails applicationDetails = msaCode.getApplicationDetails();
        MinecraftAuth.LOGGER.info("Getting MSA Token...");
        HashMap<String, String> postData = new HashMap<String, String>();
        postData.put("client_id", applicationDetails.getClientId());
        postData.put("scope", applicationDetails.getScope());
        postData.put("grant_type", type);
        if (type.equals("refresh_token")) {
            postData.put("refresh_token", code);
        } else {
            postData.put("code", code);
            postData.put("redirect_uri", applicationDetails.getRedirectUri());
        }
        if (applicationDetails.getClientSecret() != null) {
            postData.put("client_secret", applicationDetails.getClientSecret());
        }
        PostRequest postRequest = new PostRequest(applicationDetails.getOAuthEnvironment().getTokenUrl());
        postRequest.setContent((HttpContent)new URLEncodedFormContent(postData));
        JsonObject obj = (JsonObject)httpClient.execute((HttpRequest)postRequest, (HttpResponseHandler)new MsaResponseHandler());
        MsaToken msaToken = new MsaToken(System.currentTimeMillis() + obj.get("expires_in").getAsLong() * 1000L, obj.get("access_token").getAsString(), JsonUtil.getStringOr(obj, "refresh_token", null), JsonUtil.getStringOr(obj, "id_token", null), msaCode);
        MinecraftAuth.LOGGER.info("Got MSA Token, expires: " + Instant.ofEpochMilli(msaToken.getExpireTimeMs()).atZone(ZoneId.systemDefault()));
        return msaToken;
    }

    public static final class MsaToken
    extends AbstractStep.StepResult<MsaCodeStep.MsaCode> {
        private final long expireTimeMs;
        private final String accessToken;
        private final String refreshToken;
        private final String idToken;
        private final MsaCodeStep.MsaCode msaCode;

        @Override
        protected MsaCodeStep.MsaCode prevResult() {
            return this.msaCode;
        }

        @Override
        public boolean isExpired() {
            return this.expireTimeMs <= System.currentTimeMillis();
        }

        public MsaToken(long expireTimeMs, String accessToken, String refreshToken, String idToken, MsaCodeStep.MsaCode msaCode) {
            this.expireTimeMs = expireTimeMs;
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.idToken = idToken;
            this.msaCode = msaCode;
        }

        public long getExpireTimeMs() {
            return this.expireTimeMs;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public String getIdToken() {
            return this.idToken;
        }

        public MsaCodeStep.MsaCode getMsaCode() {
            return this.msaCode;
        }

        public String toString() {
            return "StepMsaToken.MsaToken(expireTimeMs=" + this.getExpireTimeMs() + ", accessToken=" + this.getAccessToken() + ", refreshToken=" + this.getRefreshToken() + ", idToken=" + this.getIdToken() + ", msaCode=" + this.getMsaCode() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MsaToken)) {
                return false;
            }
            MsaToken other = (MsaToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
                return false;
            }
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
                return false;
            }
            String this$refreshToken = this.getRefreshToken();
            String other$refreshToken = other.getRefreshToken();
            if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
                return false;
            }
            String this$idToken = this.getIdToken();
            String other$idToken = other.getIdToken();
            if (this$idToken == null ? other$idToken != null : !this$idToken.equals(other$idToken)) {
                return false;
            }
            MsaCodeStep.MsaCode this$msaCode = this.getMsaCode();
            MsaCodeStep.MsaCode other$msaCode = other.getMsaCode();
            return !(this$msaCode == null ? other$msaCode != null : !((Object)this$msaCode).equals(other$msaCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MsaToken;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expireTimeMs = this.getExpireTimeMs();
            result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            String $refreshToken = this.getRefreshToken();
            result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
            String $idToken = this.getIdToken();
            result = result * 59 + ($idToken == null ? 43 : $idToken.hashCode());
            MsaCodeStep.MsaCode $msaCode = this.getMsaCode();
            result = result * 59 + ($msaCode == null ? 43 : ((Object)$msaCode).hashCode());
            return result;
        }
    }
}

