/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.xbl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Base64;
import java.util.UUID;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.handler.HttpResponseHandler;
import net.lenni0451.commons.httpclient.model.HttpHeader;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.responsehandler.XblResponseHandler;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.util.CryptUtil;
import net.raphimc.minecraftauth.util.JsonContent;

public class StepXblDeviceToken
extends AbstractStep<AbstractStep.StepResult<?>, XblDeviceToken> {
    public static final String XBL_DEVICE_URL = "https://device.auth.xboxlive.com/device/authenticate";
    private final String deviceType;

    public StepXblDeviceToken(String deviceType) {
        super("xblDeviceToken", null);
        this.deviceType = deviceType;
    }

    @Override
    public XblDeviceToken applyStep(HttpClient httpClient, AbstractStep.StepResult<?> prevResult) throws Exception {
        MinecraftAuth.LOGGER.info("Authenticating device with Xbox Live...");
        UUID id = UUID.randomUUID();
        KeyPairGenerator secp256r1 = KeyPairGenerator.getInstance("EC");
        secp256r1.initialize(new ECGenParameterSpec("secp256r1"));
        KeyPair ecdsa256KeyPair = secp256r1.generateKeyPair();
        ECPublicKey publicKey = (ECPublicKey)ecdsa256KeyPair.getPublic();
        ECPrivateKey privateKey = (ECPrivateKey)ecdsa256KeyPair.getPrivate();
        JsonObject postData = new JsonObject();
        JsonObject properties = new JsonObject();
        properties.addProperty("AuthMethod", "ProofOfPossession");
        properties.addProperty("DeviceType", this.deviceType);
        properties.addProperty("Id", "{" + id + "}");
        properties.add("ProofKey", (JsonElement)CryptUtil.getProofKey(publicKey));
        properties.addProperty("Version", "0.0.0");
        postData.add("Properties", (JsonElement)properties);
        postData.addProperty("RelyingParty", "http://auth.xboxlive.com");
        postData.addProperty("TokenType", "JWT");
        PostRequest postRequest = new PostRequest(XBL_DEVICE_URL);
        postRequest.setContent((HttpContent)new JsonContent(postData));
        postRequest.setHeader("x-xbl-contract-version", "1");
        postRequest.setHeader(new HttpHeader[]{CryptUtil.getSignatureHeader((HttpRequest)postRequest, privateKey)});
        JsonObject obj = (JsonObject)httpClient.execute((HttpRequest)postRequest, (HttpResponseHandler)new XblResponseHandler());
        XblDeviceToken xblDeviceToken = new XblDeviceToken(publicKey, privateKey, id, Instant.parse(obj.get("NotAfter").getAsString()).toEpochMilli(), obj.get("Token").getAsString(), obj.getAsJsonObject("DisplayClaims").getAsJsonObject("xdi").get("did").getAsString());
        MinecraftAuth.LOGGER.info("Got XBL Device Token, expires: " + Instant.ofEpochMilli(xblDeviceToken.getExpireTimeMs()).atZone(ZoneId.systemDefault()));
        return xblDeviceToken;
    }

    @Override
    public XblDeviceToken fromJson(JsonObject json) {
        return new XblDeviceToken((ECPublicKey)CryptUtil.publicKeyEcFromBase64(json.get("publicKey").getAsString()), (ECPrivateKey)CryptUtil.privateKeyEcFromBase64(json.get("privateKey").getAsString()), UUID.fromString(json.get("id").getAsString()), json.get("expireTimeMs").getAsLong(), json.get("token").getAsString(), json.get("deviceId").getAsString());
    }

    @Override
    public JsonObject toJson(XblDeviceToken xblDeviceToken) {
        JsonObject json = new JsonObject();
        json.addProperty("publicKey", Base64.getEncoder().encodeToString(xblDeviceToken.publicKey.getEncoded()));
        json.addProperty("privateKey", Base64.getEncoder().encodeToString(xblDeviceToken.privateKey.getEncoded()));
        json.addProperty("id", xblDeviceToken.id.toString());
        json.addProperty("expireTimeMs", (Number)xblDeviceToken.expireTimeMs);
        json.addProperty("token", xblDeviceToken.token);
        json.addProperty("deviceId", xblDeviceToken.deviceId);
        return json;
    }

    public static final class XblDeviceToken
    extends AbstractStep.FirstStepResult {
        private final ECPublicKey publicKey;
        private final ECPrivateKey privateKey;
        private final UUID id;
        private final long expireTimeMs;
        private final String token;
        private final String deviceId;

        @Override
        public boolean isExpired() {
            return this.expireTimeMs <= System.currentTimeMillis();
        }

        public XblDeviceToken(ECPublicKey publicKey, ECPrivateKey privateKey, UUID id, long expireTimeMs, String token, String deviceId) {
            this.publicKey = publicKey;
            this.privateKey = privateKey;
            this.id = id;
            this.expireTimeMs = expireTimeMs;
            this.token = token;
            this.deviceId = deviceId;
        }

        public ECPublicKey getPublicKey() {
            return this.publicKey;
        }

        public ECPrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public UUID getId() {
            return this.id;
        }

        public long getExpireTimeMs() {
            return this.expireTimeMs;
        }

        public String getToken() {
            return this.token;
        }

        public String getDeviceId() {
            return this.deviceId;
        }

        public String toString() {
            return "StepXblDeviceToken.XblDeviceToken(publicKey=" + this.getPublicKey() + ", privateKey=" + this.getPrivateKey() + ", id=" + this.getId() + ", expireTimeMs=" + this.getExpireTimeMs() + ", token=" + this.getToken() + ", deviceId=" + this.getDeviceId() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XblDeviceToken)) {
                return false;
            }
            XblDeviceToken other = (XblDeviceToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
                return false;
            }
            ECPublicKey this$publicKey = this.getPublicKey();
            ECPublicKey other$publicKey = other.getPublicKey();
            if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
                return false;
            }
            ECPrivateKey this$privateKey = this.getPrivateKey();
            ECPrivateKey other$privateKey = other.getPrivateKey();
            if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            String this$deviceId = this.getDeviceId();
            String other$deviceId = other.getDeviceId();
            return !(this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof XblDeviceToken;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expireTimeMs = this.getExpireTimeMs();
            result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
            ECPublicKey $publicKey = this.getPublicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            ECPrivateKey $privateKey = this.getPrivateKey();
            result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            String $deviceId = this.getDeviceId();
            result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
            return result;
        }
    }
}

