/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.xbl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Instant;
import java.time.ZoneId;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.handler.HttpResponseHandler;
import net.lenni0451.commons.httpclient.model.HttpHeader;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.responsehandler.XblResponseHandler;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.xbl.StepXblTitleToken;
import net.raphimc.minecraftauth.step.xbl.StepXblUserToken;
import net.raphimc.minecraftauth.step.xbl.StepXblXstsToken;
import net.raphimc.minecraftauth.step.xbl.session.StepFullXblSession;
import net.raphimc.minecraftauth.step.xbl.session.StepInitialXblSession;
import net.raphimc.minecraftauth.util.CryptUtil;
import net.raphimc.minecraftauth.util.JsonContent;

public class StepXblSisuAuthentication
extends AbstractStep<StepInitialXblSession.InitialXblSession, XblSisuTokens> {
    public static final String XBL_SISU_URL = "https://sisu.xboxlive.com/authorize";
    private final String relyingParty;

    public StepXblSisuAuthentication(AbstractStep<?, StepInitialXblSession.InitialXblSession> prevStep, String relyingParty) {
        super("xblSisuAuthentication", prevStep);
        this.relyingParty = relyingParty;
    }

    @Override
    public XblSisuTokens applyStep(HttpClient httpClient, StepInitialXblSession.InitialXblSession initialXblSession) throws Exception {
        MinecraftAuth.LOGGER.info("Authenticating with Xbox Live using SISU...");
        if (initialXblSession.getXblDeviceToken() == null) {
            throw new IllegalStateException("An XBL Device Token is needed for SISU authentication");
        }
        if (!initialXblSession.getMsaToken().getMsaCode().getApplicationDetails().isTitleClientId()) {
            throw new IllegalStateException("A Title Client ID is needed for SISU authentication");
        }
        JsonObject postData = new JsonObject();
        postData.addProperty("AccessToken", "t=" + initialXblSession.getMsaToken().getAccessToken());
        postData.addProperty("DeviceToken", initialXblSession.getXblDeviceToken().getToken());
        postData.addProperty("AppId", initialXblSession.getMsaToken().getMsaCode().getApplicationDetails().getClientId());
        postData.add("ProofKey", (JsonElement)CryptUtil.getProofKey(initialXblSession.getXblDeviceToken().getPublicKey()));
        postData.addProperty("SiteName", "user.auth.xboxlive.com");
        postData.addProperty("RelyingParty", this.relyingParty);
        postData.addProperty("Sandbox", "RETAIL");
        postData.addProperty("UseModernGamertag", Boolean.valueOf(true));
        PostRequest postRequest = new PostRequest(XBL_SISU_URL);
        postRequest.setContent((HttpContent)new JsonContent(postData));
        postRequest.setHeader(new HttpHeader[]{CryptUtil.getSignatureHeader((HttpRequest)postRequest, initialXblSession.getXblDeviceToken().getPrivateKey())});
        JsonObject obj = (JsonObject)httpClient.execute((HttpRequest)postRequest, (HttpResponseHandler)new XblResponseHandler());
        XblSisuTokens xblSisuTokens = new XblSisuTokens(new XblSisuTokens.SisuTitleToken(Instant.parse(obj.getAsJsonObject("TitleToken").get("NotAfter").getAsString()).toEpochMilli(), obj.getAsJsonObject("TitleToken").get("Token").getAsString(), obj.getAsJsonObject("TitleToken").getAsJsonObject("DisplayClaims").getAsJsonObject("xti").get("tid").getAsString()), new XblSisuTokens.SisuUserToken(Instant.parse(obj.getAsJsonObject("UserToken").get("NotAfter").getAsString()).toEpochMilli(), obj.getAsJsonObject("UserToken").get("Token").getAsString(), obj.getAsJsonObject("UserToken").getAsJsonObject("DisplayClaims").getAsJsonArray("xui").get(0).getAsJsonObject().get("uhs").getAsString()), new XblSisuTokens.SisuXstsToken(Instant.parse(obj.getAsJsonObject("AuthorizationToken").get("NotAfter").getAsString()).toEpochMilli(), obj.getAsJsonObject("AuthorizationToken").get("Token").getAsString(), obj.getAsJsonObject("AuthorizationToken").getAsJsonObject("DisplayClaims").getAsJsonArray("xui").get(0).getAsJsonObject().get("uhs").getAsString()), initialXblSession);
        MinecraftAuth.LOGGER.info("Got XBL Title+User+XSTS Token, expires: " + Instant.ofEpochMilli(xblSisuTokens.getExpireTimeMs()).atZone(ZoneId.systemDefault()));
        return xblSisuTokens;
    }

    @Override
    public XblSisuTokens fromJson(JsonObject json) {
        StepInitialXblSession.InitialXblSession initialXblSession = this.prevStep != null ? (StepInitialXblSession.InitialXblSession)this.prevStep.fromJson(json.getAsJsonObject(this.prevStep.name)) : null;
        return new XblSisuTokens(XblSisuTokens.SisuTitleToken.fromJson(json.getAsJsonObject("titleToken")), XblSisuTokens.SisuUserToken.fromJson(json.getAsJsonObject("userToken")), XblSisuTokens.SisuXstsToken.fromJson(json.getAsJsonObject("xstsToken")), initialXblSession);
    }

    @Override
    public JsonObject toJson(XblSisuTokens xblSisuTokens) {
        JsonObject json = new JsonObject();
        json.add("titleToken", (JsonElement)XblSisuTokens.SisuTitleToken.toJson(xblSisuTokens.titleToken));
        json.add("userToken", (JsonElement)XblSisuTokens.SisuUserToken.toJson(xblSisuTokens.userToken));
        json.add("xstsToken", (JsonElement)XblSisuTokens.SisuXstsToken.toJson(xblSisuTokens.xstsToken));
        if (this.prevStep != null) {
            json.add(this.prevStep.name, (JsonElement)this.prevStep.toJson(xblSisuTokens.initialXblSession));
        }
        return json;
    }

    public static final class XblSisuTokens
    extends StepXblXstsToken.XblXsts<StepInitialXblSession.InitialXblSession> {
        private final SisuTitleToken titleToken;
        private final SisuUserToken userToken;
        private final SisuXstsToken xstsToken;
        private final StepInitialXblSession.InitialXblSession initialXblSession;

        @Override
        public long getExpireTimeMs() {
            return Math.min(Math.min(this.xstsToken.expireTimeMs, this.titleToken.expireTimeMs), this.userToken.expireTimeMs);
        }

        @Override
        public String getToken() {
            return this.xstsToken.token;
        }

        @Override
        public String getUserHash() {
            return this.xstsToken.userHash;
        }

        @Override
        public StepFullXblSession.FullXblSession getFullXblSession() {
            StepXblUserToken.XblUserToken userToken = new StepXblUserToken.XblUserToken(this.userToken.expireTimeMs, this.userToken.token, this.userToken.userHash, this.initialXblSession);
            StepXblTitleToken.XblTitleToken titleToken = new StepXblTitleToken.XblTitleToken(this.titleToken.expireTimeMs, this.titleToken.token, this.titleToken.titleId, this.initialXblSession);
            return new StepFullXblSession.FullXblSession(userToken, titleToken);
        }

        @Override
        protected StepInitialXblSession.InitialXblSession prevResult() {
            return this.initialXblSession;
        }

        @Override
        public boolean isExpired() {
            return this.getExpireTimeMs() <= System.currentTimeMillis();
        }

        public XblSisuTokens(SisuTitleToken titleToken, SisuUserToken userToken, SisuXstsToken xstsToken, StepInitialXblSession.InitialXblSession initialXblSession) {
            this.titleToken = titleToken;
            this.userToken = userToken;
            this.xstsToken = xstsToken;
            this.initialXblSession = initialXblSession;
        }

        public SisuTitleToken getTitleToken() {
            return this.titleToken;
        }

        public SisuUserToken getUserToken() {
            return this.userToken;
        }

        public SisuXstsToken getXstsToken() {
            return this.xstsToken;
        }

        @Override
        public StepInitialXblSession.InitialXblSession getInitialXblSession() {
            return this.initialXblSession;
        }

        public String toString() {
            return "StepXblSisuAuthentication.XblSisuTokens(titleToken=" + this.getTitleToken() + ", userToken=" + this.getUserToken() + ", xstsToken=" + this.getXstsToken() + ", initialXblSession=" + this.getInitialXblSession() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XblSisuTokens)) {
                return false;
            }
            XblSisuTokens other = (XblSisuTokens)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SisuTitleToken this$titleToken = this.getTitleToken();
            SisuTitleToken other$titleToken = other.getTitleToken();
            if (this$titleToken == null ? other$titleToken != null : !((Object)this$titleToken).equals(other$titleToken)) {
                return false;
            }
            SisuUserToken this$userToken = this.getUserToken();
            SisuUserToken other$userToken = other.getUserToken();
            if (this$userToken == null ? other$userToken != null : !((Object)this$userToken).equals(other$userToken)) {
                return false;
            }
            SisuXstsToken this$xstsToken = this.getXstsToken();
            SisuXstsToken other$xstsToken = other.getXstsToken();
            if (this$xstsToken == null ? other$xstsToken != null : !((Object)this$xstsToken).equals(other$xstsToken)) {
                return false;
            }
            StepInitialXblSession.InitialXblSession this$initialXblSession = this.getInitialXblSession();
            StepInitialXblSession.InitialXblSession other$initialXblSession = other.getInitialXblSession();
            return !(this$initialXblSession == null ? other$initialXblSession != null : !((Object)this$initialXblSession).equals(other$initialXblSession));
        }

        protected boolean canEqual(Object other) {
            return other instanceof XblSisuTokens;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SisuTitleToken $titleToken = this.getTitleToken();
            result = result * 59 + ($titleToken == null ? 43 : ((Object)$titleToken).hashCode());
            SisuUserToken $userToken = this.getUserToken();
            result = result * 59 + ($userToken == null ? 43 : ((Object)$userToken).hashCode());
            SisuXstsToken $xstsToken = this.getXstsToken();
            result = result * 59 + ($xstsToken == null ? 43 : ((Object)$xstsToken).hashCode());
            StepInitialXblSession.InitialXblSession $initialXblSession = this.getInitialXblSession();
            result = result * 59 + ($initialXblSession == null ? 43 : ((Object)$initialXblSession).hashCode());
            return result;
        }

        public static final class SisuXstsToken {
            private final long expireTimeMs;
            private final String token;
            private final String userHash;

            public static SisuXstsToken fromJson(JsonObject json) {
                return new SisuXstsToken(json.get("expireTimeMs").getAsLong(), json.get("token").getAsString(), json.get("userHash").getAsString());
            }

            public static JsonObject toJson(SisuXstsToken sisuXstsToken) {
                JsonObject json = new JsonObject();
                json.addProperty("expireTimeMs", (Number)sisuXstsToken.expireTimeMs);
                json.addProperty("token", sisuXstsToken.token);
                json.addProperty("userHash", sisuXstsToken.userHash);
                return json;
            }

            public SisuXstsToken(long expireTimeMs, String token, String userHash) {
                this.expireTimeMs = expireTimeMs;
                this.token = token;
                this.userHash = userHash;
            }

            public long getExpireTimeMs() {
                return this.expireTimeMs;
            }

            public String getToken() {
                return this.token;
            }

            public String getUserHash() {
                return this.userHash;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SisuXstsToken)) {
                    return false;
                }
                SisuXstsToken other = (SisuXstsToken)o;
                if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
                    return false;
                }
                String this$token = this.getToken();
                String other$token = other.getToken();
                if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                    return false;
                }
                String this$userHash = this.getUserHash();
                String other$userHash = other.getUserHash();
                return !(this$userHash == null ? other$userHash != null : !this$userHash.equals(other$userHash));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $expireTimeMs = this.getExpireTimeMs();
                result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
                String $token = this.getToken();
                result = result * 59 + ($token == null ? 43 : $token.hashCode());
                String $userHash = this.getUserHash();
                result = result * 59 + ($userHash == null ? 43 : $userHash.hashCode());
                return result;
            }

            public String toString() {
                return "StepXblSisuAuthentication.XblSisuTokens.SisuXstsToken(expireTimeMs=" + this.getExpireTimeMs() + ", token=" + this.getToken() + ", userHash=" + this.getUserHash() + ")";
            }
        }

        public static final class SisuUserToken {
            private final long expireTimeMs;
            private final String token;
            private final String userHash;

            public static SisuUserToken fromJson(JsonObject json) {
                return new SisuUserToken(json.get("expireTimeMs").getAsLong(), json.get("token").getAsString(), json.get("userHash").getAsString());
            }

            public static JsonObject toJson(SisuUserToken sisuUserToken) {
                JsonObject json = new JsonObject();
                json.addProperty("expireTimeMs", (Number)sisuUserToken.expireTimeMs);
                json.addProperty("token", sisuUserToken.token);
                json.addProperty("userHash", sisuUserToken.userHash);
                return json;
            }

            public SisuUserToken(long expireTimeMs, String token, String userHash) {
                this.expireTimeMs = expireTimeMs;
                this.token = token;
                this.userHash = userHash;
            }

            public long getExpireTimeMs() {
                return this.expireTimeMs;
            }

            public String getToken() {
                return this.token;
            }

            public String getUserHash() {
                return this.userHash;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SisuUserToken)) {
                    return false;
                }
                SisuUserToken other = (SisuUserToken)o;
                if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
                    return false;
                }
                String this$token = this.getToken();
                String other$token = other.getToken();
                if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                    return false;
                }
                String this$userHash = this.getUserHash();
                String other$userHash = other.getUserHash();
                return !(this$userHash == null ? other$userHash != null : !this$userHash.equals(other$userHash));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $expireTimeMs = this.getExpireTimeMs();
                result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
                String $token = this.getToken();
                result = result * 59 + ($token == null ? 43 : $token.hashCode());
                String $userHash = this.getUserHash();
                result = result * 59 + ($userHash == null ? 43 : $userHash.hashCode());
                return result;
            }

            public String toString() {
                return "StepXblSisuAuthentication.XblSisuTokens.SisuUserToken(expireTimeMs=" + this.getExpireTimeMs() + ", token=" + this.getToken() + ", userHash=" + this.getUserHash() + ")";
            }
        }

        public static final class SisuTitleToken {
            private final long expireTimeMs;
            private final String token;
            private final String titleId;

            public static SisuTitleToken fromJson(JsonObject json) {
                return new SisuTitleToken(json.get("expireTimeMs").getAsLong(), json.get("token").getAsString(), json.get("titleId").getAsString());
            }

            public static JsonObject toJson(SisuTitleToken sisuTitleToken) {
                JsonObject json = new JsonObject();
                json.addProperty("expireTimeMs", (Number)sisuTitleToken.expireTimeMs);
                json.addProperty("token", sisuTitleToken.token);
                json.addProperty("titleId", sisuTitleToken.titleId);
                return json;
            }

            public SisuTitleToken(long expireTimeMs, String token, String titleId) {
                this.expireTimeMs = expireTimeMs;
                this.token = token;
                this.titleId = titleId;
            }

            public long getExpireTimeMs() {
                return this.expireTimeMs;
            }

            public String getToken() {
                return this.token;
            }

            public String getTitleId() {
                return this.titleId;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SisuTitleToken)) {
                    return false;
                }
                SisuTitleToken other = (SisuTitleToken)o;
                if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
                    return false;
                }
                String this$token = this.getToken();
                String other$token = other.getToken();
                if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                    return false;
                }
                String this$titleId = this.getTitleId();
                String other$titleId = other.getTitleId();
                return !(this$titleId == null ? other$titleId != null : !this$titleId.equals(other$titleId));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $expireTimeMs = this.getExpireTimeMs();
                result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
                String $token = this.getToken();
                result = result * 59 + ($token == null ? 43 : $token.hashCode());
                String $titleId = this.getTitleId();
                result = result * 59 + ($titleId == null ? 43 : $titleId.hashCode());
                return result;
            }

            public String toString() {
                return "StepXblSisuAuthentication.XblSisuTokens.SisuTitleToken(expireTimeMs=" + this.getExpireTimeMs() + ", token=" + this.getToken() + ", titleId=" + this.getTitleId() + ")";
            }
        }
    }
}

