/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.xbl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Instant;
import java.time.ZoneId;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.handler.HttpResponseHandler;
import net.lenni0451.commons.httpclient.model.HttpHeader;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.responsehandler.XblResponseHandler;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.xbl.session.StepInitialXblSession;
import net.raphimc.minecraftauth.util.CryptUtil;
import net.raphimc.minecraftauth.util.JsonContent;

public class StepXblTitleToken
extends AbstractStep<StepInitialXblSession.InitialXblSession, XblTitleToken> {
    public static final String XBL_TITLE_URL = "https://title.auth.xboxlive.com/title/authenticate";

    public StepXblTitleToken(AbstractStep<?, StepInitialXblSession.InitialXblSession> prevStep) {
        super("titleToken", prevStep);
    }

    @Override
    public XblTitleToken applyStep(HttpClient httpClient, StepInitialXblSession.InitialXblSession initialXblSession) throws Exception {
        MinecraftAuth.LOGGER.info("Authenticating title with Xbox Live...");
        if (initialXblSession.getXblDeviceToken() == null) {
            throw new IllegalStateException("An XBL Device Token is needed for Title authentication");
        }
        if (!initialXblSession.getMsaToken().getMsaCode().getApplicationDetails().isTitleClientId()) {
            throw new IllegalStateException("A Title Client ID is needed for Title authentication");
        }
        JsonObject postData = new JsonObject();
        JsonObject properties = new JsonObject();
        properties.addProperty("AuthMethod", "RPS");
        properties.addProperty("SiteName", "user.auth.xboxlive.com");
        properties.addProperty("RpsTicket", "t=" + initialXblSession.getMsaToken().getAccessToken());
        properties.addProperty("DeviceToken", initialXblSession.getXblDeviceToken().getToken());
        properties.add("ProofKey", (JsonElement)CryptUtil.getProofKey(initialXblSession.getXblDeviceToken().getPublicKey()));
        postData.add("Properties", (JsonElement)properties);
        postData.addProperty("RelyingParty", "http://auth.xboxlive.com");
        postData.addProperty("TokenType", "JWT");
        PostRequest postRequest = new PostRequest(XBL_TITLE_URL);
        postRequest.setContent((HttpContent)new JsonContent(postData));
        postRequest.setHeader("x-xbl-contract-version", "1");
        postRequest.setHeader(new HttpHeader[]{CryptUtil.getSignatureHeader((HttpRequest)postRequest, initialXblSession.getXblDeviceToken().getPrivateKey())});
        JsonObject obj = (JsonObject)httpClient.execute((HttpRequest)postRequest, (HttpResponseHandler)new XblResponseHandler());
        XblTitleToken xblTitleToken = new XblTitleToken(Instant.parse(obj.get("NotAfter").getAsString()).toEpochMilli(), obj.get("Token").getAsString(), obj.getAsJsonObject("DisplayClaims").getAsJsonObject("xti").get("tid").getAsString(), initialXblSession);
        MinecraftAuth.LOGGER.info("Got XBL Title Token, expires: " + Instant.ofEpochMilli(xblTitleToken.getExpireTimeMs()).atZone(ZoneId.systemDefault()));
        return xblTitleToken;
    }

    @Override
    public XblTitleToken fromJson(JsonObject json) {
        StepInitialXblSession.InitialXblSession initialXblSession = this.prevStep != null ? (StepInitialXblSession.InitialXblSession)this.prevStep.fromJson(json.getAsJsonObject(this.prevStep.name)) : null;
        return new XblTitleToken(json.get("expireTimeMs").getAsLong(), json.get("token").getAsString(), json.get("titleId").getAsString(), initialXblSession);
    }

    @Override
    public JsonObject toJson(XblTitleToken xblTitleToken) {
        JsonObject json = new JsonObject();
        json.addProperty("expireTimeMs", (Number)xblTitleToken.expireTimeMs);
        json.addProperty("token", xblTitleToken.token);
        json.addProperty("titleId", xblTitleToken.titleId);
        if (this.prevStep != null) {
            json.add(this.prevStep.name, (JsonElement)this.prevStep.toJson(xblTitleToken.initialXblSession));
        }
        return json;
    }

    public static final class XblTitleToken
    extends AbstractStep.StepResult<StepInitialXblSession.InitialXblSession> {
        private final long expireTimeMs;
        private final String token;
        private final String titleId;
        private final StepInitialXblSession.InitialXblSession initialXblSession;

        @Override
        protected StepInitialXblSession.InitialXblSession prevResult() {
            return this.initialXblSession;
        }

        @Override
        public boolean isExpired() {
            return this.expireTimeMs <= System.currentTimeMillis();
        }

        public XblTitleToken(long expireTimeMs, String token, String titleId, StepInitialXblSession.InitialXblSession initialXblSession) {
            this.expireTimeMs = expireTimeMs;
            this.token = token;
            this.titleId = titleId;
            this.initialXblSession = initialXblSession;
        }

        public long getExpireTimeMs() {
            return this.expireTimeMs;
        }

        public String getToken() {
            return this.token;
        }

        public String getTitleId() {
            return this.titleId;
        }

        public StepInitialXblSession.InitialXblSession getInitialXblSession() {
            return this.initialXblSession;
        }

        public String toString() {
            return "StepXblTitleToken.XblTitleToken(expireTimeMs=" + this.getExpireTimeMs() + ", token=" + this.getToken() + ", titleId=" + this.getTitleId() + ", initialXblSession=" + this.getInitialXblSession() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XblTitleToken)) {
                return false;
            }
            XblTitleToken other = (XblTitleToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            String this$titleId = this.getTitleId();
            String other$titleId = other.getTitleId();
            if (this$titleId == null ? other$titleId != null : !this$titleId.equals(other$titleId)) {
                return false;
            }
            StepInitialXblSession.InitialXblSession this$initialXblSession = this.getInitialXblSession();
            StepInitialXblSession.InitialXblSession other$initialXblSession = other.getInitialXblSession();
            return !(this$initialXblSession == null ? other$initialXblSession != null : !((Object)this$initialXblSession).equals(other$initialXblSession));
        }

        protected boolean canEqual(Object other) {
            return other instanceof XblTitleToken;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expireTimeMs = this.getExpireTimeMs();
            result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            String $titleId = this.getTitleId();
            result = result * 59 + ($titleId == null ? 43 : $titleId.hashCode());
            StepInitialXblSession.InitialXblSession $initialXblSession = this.getInitialXblSession();
            result = result * 59 + ($initialXblSession == null ? 43 : ((Object)$initialXblSession).hashCode());
            return result;
        }
    }
}

