/*
 * This file is part of MinecraftAuth - https://github.com/RaphiMC/MinecraftAuth
 * Copyright (C) 2022-2024 RK_01/RaphiMC and contributors
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package net.raphimc.minecraftauth.service.realms.model;

import com.google.gson.JsonObject;
import net.raphimc.minecraftauth.util.JsonUtil;
import java.util.UUID;

public final class RealmsWorld {
    private final long id;
    private final String ownerName;
    private final String ownerUuidOrXuid;
    private final String name;
    private final String motd;
    private final String state;
    private final boolean expired;
    private final String worldType;
    private final int maxPlayers;
    private final boolean compatible;
    private final String activeVersion;
    private final JsonObject rawResponse;

    public static RealmsWorld fromJson(final JsonObject json) {
        return new RealmsWorld(JsonUtil.getLongOr(json, "id", -1L), JsonUtil.getStringOr(json, "owner", null), JsonUtil.getStringOr(json, "ownerUUID", new UUID(0L, 0L).toString()), JsonUtil.getStringOr(json, "name", null), JsonUtil.getStringOr(json, "motd", null), JsonUtil.getStringOr(json, "state", "CLOSED"), JsonUtil.getBooleanOr(json, "expired", false), JsonUtil.getStringOr(json, "worldType", "NORMAL"), JsonUtil.getIntOr(json, "maxPlayers", 0), JsonUtil.getStringOr(json, "compatibility", "COMPATIBLE").equals("COMPATIBLE"), JsonUtil.getStringOr(json, "activeVersion", ""), json);
    }

    public RealmsWorld(final long id, final String ownerName, final String ownerUuidOrXuid, final String name, final String motd, final String state, final boolean expired, final String worldType, final int maxPlayers, final boolean compatible, final String activeVersion, final JsonObject rawResponse) {
        this.id = id;
        this.ownerName = ownerName;
        this.ownerUuidOrXuid = ownerUuidOrXuid;
        this.name = name;
        this.motd = motd;
        this.state = state;
        this.expired = expired;
        this.worldType = worldType;
        this.maxPlayers = maxPlayers;
        this.compatible = compatible;
        this.activeVersion = activeVersion;
        this.rawResponse = rawResponse;
    }

    public long getId() {
        return this.id;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getOwnerUuidOrXuid() {
        return this.ownerUuidOrXuid;
    }

    public String getName() {
        return this.name;
    }

    public String getMotd() {
        return this.motd;
    }

    public String getState() {
        return this.state;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public String getWorldType() {
        return this.worldType;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public String getActiveVersion() {
        return this.activeVersion;
    }

    public JsonObject getRawResponse() {
        return this.rawResponse;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == this) return true;
        if (!(o instanceof RealmsWorld)) return false;
        final RealmsWorld other = (RealmsWorld) o;
        if (this.getId() != other.getId()) return false;
        if (this.isExpired() != other.isExpired()) return false;
        if (this.getMaxPlayers() != other.getMaxPlayers()) return false;
        if (this.isCompatible() != other.isCompatible()) return false;
        final Object this$ownerName = this.getOwnerName();
        final Object other$ownerName = other.getOwnerName();
        if (this$ownerName == null ? other$ownerName != null : !this$ownerName.equals(other$ownerName)) return false;
        final Object this$ownerUuidOrXuid = this.getOwnerUuidOrXuid();
        final Object other$ownerUuidOrXuid = other.getOwnerUuidOrXuid();
        if (this$ownerUuidOrXuid == null ? other$ownerUuidOrXuid != null : !this$ownerUuidOrXuid.equals(other$ownerUuidOrXuid)) return false;
        final Object this$name = this.getName();
        final Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final Object this$motd = this.getMotd();
        final Object other$motd = other.getMotd();
        if (this$motd == null ? other$motd != null : !this$motd.equals(other$motd)) return false;
        final Object this$state = this.getState();
        final Object other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) return false;
        final Object this$worldType = this.getWorldType();
        final Object other$worldType = other.getWorldType();
        if (this$worldType == null ? other$worldType != null : !this$worldType.equals(other$worldType)) return false;
        final Object this$activeVersion = this.getActiveVersion();
        final Object other$activeVersion = other.getActiveVersion();
        if (this$activeVersion == null ? other$activeVersion != null : !this$activeVersion.equals(other$activeVersion)) return false;
        final Object this$rawResponse = this.getRawResponse();
        final Object other$rawResponse = other.getRawResponse();
        if (this$rawResponse == null ? other$rawResponse != null : !this$rawResponse.equals(other$rawResponse)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final long $id = this.getId();
        result = result * PRIME + (int) ($id >>> 32 ^ $id);
        result = result * PRIME + (this.isExpired() ? 79 : 97);
        result = result * PRIME + this.getMaxPlayers();
        result = result * PRIME + (this.isCompatible() ? 79 : 97);
        final Object $ownerName = this.getOwnerName();
        result = result * PRIME + ($ownerName == null ? 43 : $ownerName.hashCode());
        final Object $ownerUuidOrXuid = this.getOwnerUuidOrXuid();
        result = result * PRIME + ($ownerUuidOrXuid == null ? 43 : $ownerUuidOrXuid.hashCode());
        final Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final Object $motd = this.getMotd();
        result = result * PRIME + ($motd == null ? 43 : $motd.hashCode());
        final Object $state = this.getState();
        result = result * PRIME + ($state == null ? 43 : $state.hashCode());
        final Object $worldType = this.getWorldType();
        result = result * PRIME + ($worldType == null ? 43 : $worldType.hashCode());
        final Object $activeVersion = this.getActiveVersion();
        result = result * PRIME + ($activeVersion == null ? 43 : $activeVersion.hashCode());
        final Object $rawResponse = this.getRawResponse();
        result = result * PRIME + ($rawResponse == null ? 43 : $rawResponse.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RealmsWorld(id=" + this.getId() + ", ownerName=" + this.getOwnerName() + ", ownerUuidOrXuid=" + this.getOwnerUuidOrXuid() + ", name=" + this.getName() + ", motd=" + this.getMotd() + ", state=" + this.getState() + ", expired=" + this.isExpired() + ", worldType=" + this.getWorldType() + ", maxPlayers=" + this.getMaxPlayers() + ", compatible=" + this.isCompatible() + ", activeVersion=" + this.getActiveVersion() + ", rawResponse=" + this.getRawResponse() + ")";
    }
}
