/*
 * This file is part of MinecraftAuth - https://github.com/RaphiMC/MinecraftAuth
 * Copyright (C) 2022-2024 RK_01/RaphiMC and contributors
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package net.raphimc.minecraftauth.step.java.session;

import com.google.gson.JsonObject;
import net.lenni0451.commons.httpclient.HttpClient;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.BiMergeStep;
import net.raphimc.minecraftauth.step.SameInputBiMergeStep;
import net.raphimc.minecraftauth.step.java.StepMCProfile;
import net.raphimc.minecraftauth.step.java.StepPlayerCertificates;

public class StepFullJavaSession extends SameInputBiMergeStep<StepMCProfile.MCProfile, StepPlayerCertificates.PlayerCertificates, StepFullJavaSession.FullJavaSession> {
    public StepFullJavaSession(final AbstractStep<?, StepMCProfile.MCProfile> prevStep1, final AbstractStep<?, StepPlayerCertificates.PlayerCertificates> prevStep2) {
        super("fullJavaSession", prevStep1, prevStep2);
    }

    @Override
    public FullJavaSession applyStep(final HttpClient httpClient, final StepMCProfile.MCProfile mcProfile, final StepPlayerCertificates.PlayerCertificates playerCertificates) throws Exception {
        return new FullJavaSession(mcProfile, playerCertificates);
    }

    @Override
    public FullJavaSession fromRawJson(final JsonObject json) {
        final StepMCProfile.MCProfile mcProfile = this.prevStep != null ? this.prevStep.fromJson(json.getAsJsonObject(this.prevStep.name)) : null;
        final StepPlayerCertificates.PlayerCertificates playerCertificates = this.prevStep2 != null ? this.prevStep2.fromJson(json.getAsJsonObject(this.prevStep2.name)) : null;
        return new FullJavaSession(mcProfile, playerCertificates);
    }

    @Override
    public JsonObject toRawJson(final FullJavaSession fullJavaSession) {
        final JsonObject json = new JsonObject();
        if (this.prevStep != null) json.add(this.prevStep.name, this.prevStep.toJson(fullJavaSession.mcProfile));
        if (this.prevStep2 != null) json.add(this.prevStep2.name, this.prevStep2.toJson(fullJavaSession.playerCertificates));
        return json;
    }


    public static final class FullJavaSession extends BiMergeStep.StepResult<StepMCProfile.MCProfile, StepPlayerCertificates.PlayerCertificates> {
        private final StepMCProfile.MCProfile mcProfile;
        private final StepPlayerCertificates.PlayerCertificates playerCertificates;

        @Override
        protected StepMCProfile.MCProfile prevResult() {
            return this.mcProfile;
        }

        @Override
        protected StepPlayerCertificates.PlayerCertificates prevResult2() {
            return this.playerCertificates;
        }

        public FullJavaSession(final StepMCProfile.MCProfile mcProfile, final StepPlayerCertificates.PlayerCertificates playerCertificates) {
            this.mcProfile = mcProfile;
            this.playerCertificates = playerCertificates;
        }

        public StepMCProfile.MCProfile getMcProfile() {
            return this.mcProfile;
        }

        public StepPlayerCertificates.PlayerCertificates getPlayerCertificates() {
            return this.playerCertificates;
        }

        @Override
        public String toString() {
            return "StepFullJavaSession.FullJavaSession(mcProfile=" + this.getMcProfile() + ", playerCertificates=" + this.getPlayerCertificates() + ")";
        }

        @Override
        public boolean equals(final Object o) {
            if (o == this) return true;
            if (!(o instanceof StepFullJavaSession.FullJavaSession)) return false;
            final StepFullJavaSession.FullJavaSession other = (StepFullJavaSession.FullJavaSession) o;
            if (!other.canEqual((Object) this)) return false;
            final Object this$mcProfile = this.getMcProfile();
            final Object other$mcProfile = other.getMcProfile();
            if (this$mcProfile == null ? other$mcProfile != null : !this$mcProfile.equals(other$mcProfile)) return false;
            final Object this$playerCertificates = this.getPlayerCertificates();
            final Object other$playerCertificates = other.getPlayerCertificates();
            if (this$playerCertificates == null ? other$playerCertificates != null : !this$playerCertificates.equals(other$playerCertificates)) return false;
            return true;
        }

        protected boolean canEqual(final Object other) {
            return other instanceof StepFullJavaSession.FullJavaSession;
        }

        @Override
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final Object $mcProfile = this.getMcProfile();
            result = result * PRIME + ($mcProfile == null ? 43 : $mcProfile.hashCode());
            final Object $playerCertificates = this.getPlayerCertificates();
            result = result * PRIME + ($playerCertificates == null ? 43 : $playerCertificates.hashCode());
            return result;
        }
    }
}
