/*
 * This file is part of MinecraftAuth - https://github.com/RaphiMC/MinecraftAuth
 * Copyright (C) 2022-2024 RK_01/RaphiMC and contributors
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package net.raphimc.minecraftauth.step.xbl.session;

import com.google.gson.JsonObject;
import net.lenni0451.commons.httpclient.HttpClient;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.BiMergeStep;
import net.raphimc.minecraftauth.step.msa.StepMsaToken;
import net.raphimc.minecraftauth.step.xbl.StepXblDeviceToken;

public class StepInitialXblSession extends BiMergeStep<StepMsaToken.MsaToken, StepXblDeviceToken.XblDeviceToken, StepInitialXblSession.InitialXblSession> {
    public StepInitialXblSession(final AbstractStep<?, StepMsaToken.MsaToken> prevStep1, final AbstractStep<?, StepXblDeviceToken.XblDeviceToken> prevStep2) {
        super("initialXblSession", prevStep1, prevStep2);
    }

    @Override
    public InitialXblSession applyStep(final HttpClient httpClient, final StepMsaToken.MsaToken msaToken, final StepXblDeviceToken.XblDeviceToken xblDeviceToken) throws Exception {
        return new InitialXblSession(msaToken, xblDeviceToken);
    }

    @Override
    public InitialXblSession fromJson(final JsonObject json) {
        final StepMsaToken.MsaToken msaToken = this.prevStep != null ? this.prevStep.fromJson(json.getAsJsonObject(this.prevStep.name)) : null;
        final StepXblDeviceToken.XblDeviceToken xblDeviceToken = this.prevStep2 != null ? this.prevStep2.fromJson(json.getAsJsonObject(this.prevStep2.name)) : null;
        return new InitialXblSession(msaToken, xblDeviceToken);
    }

    @Override
    public JsonObject toJson(final InitialXblSession initialXblSession) {
        final JsonObject json = new JsonObject();
        if (this.prevStep != null) json.add(this.prevStep.name, this.prevStep.toJson(initialXblSession.msaToken));
        if (this.prevStep2 != null) json.add(this.prevStep2.name, this.prevStep2.toJson(initialXblSession.xblDeviceToken));
        return json;
    }


    public static final class InitialXblSession extends BiMergeStep.StepResult<StepMsaToken.MsaToken, StepXblDeviceToken.XblDeviceToken> {
        private final StepMsaToken.MsaToken msaToken;
        private final StepXblDeviceToken.XblDeviceToken xblDeviceToken;

        @Override
        protected StepMsaToken.MsaToken prevResult() {
            return this.msaToken;
        }

        @Override
        protected StepXblDeviceToken.XblDeviceToken prevResult2() {
            return this.xblDeviceToken;
        }

        public InitialXblSession(final StepMsaToken.MsaToken msaToken, final StepXblDeviceToken.XblDeviceToken xblDeviceToken) {
            this.msaToken = msaToken;
            this.xblDeviceToken = xblDeviceToken;
        }

        public StepMsaToken.MsaToken getMsaToken() {
            return this.msaToken;
        }

        public StepXblDeviceToken.XblDeviceToken getXblDeviceToken() {
            return this.xblDeviceToken;
        }

        @Override
        public String toString() {
            return "StepInitialXblSession.InitialXblSession(msaToken=" + this.getMsaToken() + ", xblDeviceToken=" + this.getXblDeviceToken() + ")";
        }

        @Override
        public boolean equals(final Object o) {
            if (o == this) return true;
            if (!(o instanceof StepInitialXblSession.InitialXblSession)) return false;
            final StepInitialXblSession.InitialXblSession other = (StepInitialXblSession.InitialXblSession) o;
            if (!other.canEqual((Object) this)) return false;
            final Object this$msaToken = this.getMsaToken();
            final Object other$msaToken = other.getMsaToken();
            if (this$msaToken == null ? other$msaToken != null : !this$msaToken.equals(other$msaToken)) return false;
            final Object this$xblDeviceToken = this.getXblDeviceToken();
            final Object other$xblDeviceToken = other.getXblDeviceToken();
            if (this$xblDeviceToken == null ? other$xblDeviceToken != null : !this$xblDeviceToken.equals(other$xblDeviceToken)) return false;
            return true;
        }

        protected boolean canEqual(final Object other) {
            return other instanceof StepInitialXblSession.InitialXblSession;
        }

        @Override
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final Object $msaToken = this.getMsaToken();
            result = result * PRIME + ($msaToken == null ? 43 : $msaToken.hashCode());
            final Object $xblDeviceToken = this.getXblDeviceToken();
            result = result * PRIME + ($xblDeviceToken == null ? 43 : $xblDeviceToken.hashCode());
            return result;
        }
    }
}
