/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.bedrock;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Instant;
import java.time.ZoneId;
import lombok.Generated;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.handler.HttpResponseHandler;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.responsehandler.PlayFabResponseHandler;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.xbl.StepXblXstsToken;
import net.raphimc.minecraftauth.util.JsonContent;
import net.raphimc.minecraftauth.util.logging.ILogger;

public class StepPlayFabToken
extends AbstractStep<StepXblXstsToken.XblXsts<?>, PlayFabToken> {
    public static final String PLAY_FAB_URL = "https://" + "20CA2".toLowerCase() + ".playfabapi.com/Client/LoginWithXbox";

    public StepPlayFabToken(AbstractStep<?, ? extends StepXblXstsToken.XblXsts<?>> prevStep) {
        super("playFabToken", prevStep);
    }

    @Override
    protected PlayFabToken execute(ILogger logger, HttpClient httpClient, StepXblXstsToken.XblXsts<?> xblXsts) throws Exception {
        logger.info(this, "Authenticating with PlayFab...");
        JsonObject postData = new JsonObject();
        postData.addProperty("CreateAccount", Boolean.valueOf(true));
        postData.add("EncryptedRequest", null);
        JsonObject infoRequestParameters = new JsonObject();
        infoRequestParameters.addProperty("GetCharacterInventories", Boolean.valueOf(false));
        infoRequestParameters.addProperty("GetCharacterList", Boolean.valueOf(false));
        infoRequestParameters.addProperty("GetPlayerProfile", Boolean.valueOf(true));
        infoRequestParameters.addProperty("GetPlayerStatistics", Boolean.valueOf(false));
        infoRequestParameters.addProperty("GetTitleData", Boolean.valueOf(false));
        infoRequestParameters.addProperty("GetUserAccountInfo", Boolean.valueOf(true));
        infoRequestParameters.addProperty("GetUserData", Boolean.valueOf(false));
        infoRequestParameters.addProperty("GetUserInventory", Boolean.valueOf(false));
        infoRequestParameters.addProperty("GetUserReadOnlyData", Boolean.valueOf(false));
        infoRequestParameters.addProperty("GetUserVirtualCurrency", Boolean.valueOf(false));
        infoRequestParameters.add("PlayerStatisticNames", null);
        infoRequestParameters.add("ProfileConstraints", null);
        infoRequestParameters.add("TitleDataKeys", null);
        infoRequestParameters.add("UserDataKeys", null);
        infoRequestParameters.add("UserReadOnlyDataKeys", null);
        postData.add("InfoRequestParameters", (JsonElement)infoRequestParameters);
        postData.add("PlayerSecret", null);
        postData.addProperty("TitleId", "20CA2");
        postData.addProperty("XboxToken", "XBL3.0 x=" + xblXsts.getServiceToken());
        PostRequest postRequest = new PostRequest(PLAY_FAB_URL);
        postRequest.setContent((HttpContent)new JsonContent(postData));
        JsonObject obj = (JsonObject)httpClient.execute((HttpRequest)postRequest, (HttpResponseHandler)new PlayFabResponseHandler());
        JsonObject data = obj.getAsJsonObject("data");
        JsonObject entityToken = data.getAsJsonObject("EntityToken");
        PlayFabToken playFabToken = new PlayFabToken(Instant.parse(entityToken.get("TokenExpiration").getAsString()).toEpochMilli(), entityToken.get("EntityToken").getAsString(), entityToken.get("Entity").getAsJsonObject().get("Id").getAsString(), data.get("SessionTicket").getAsString(), data.get("PlayFabId").getAsString(), xblXsts);
        logger.info(this, "Got PlayFab Token, expires: " + Instant.ofEpochMilli(playFabToken.getExpireTimeMs()).atZone(ZoneId.systemDefault()));
        return playFabToken;
    }

    @Override
    public PlayFabToken fromJson(JsonObject json) {
        StepXblXstsToken.XblXsts xblXsts = this.prevStep != null ? (StepXblXstsToken.XblXsts)this.prevStep.fromJson(json.getAsJsonObject(this.prevStep.name)) : null;
        return new PlayFabToken(json.get("expireTimeMs").getAsLong(), json.get("entityToken").getAsString(), json.get("entityId").getAsString(), json.get("sessionTicket").getAsString(), json.get("playFabId").getAsString(), xblXsts);
    }

    @Override
    public JsonObject toJson(PlayFabToken playFabToken) {
        JsonObject json = new JsonObject();
        json.addProperty("expireTimeMs", (Number)playFabToken.expireTimeMs);
        json.addProperty("entityToken", playFabToken.entityToken);
        json.addProperty("entityId", playFabToken.entityId);
        json.addProperty("sessionTicket", playFabToken.sessionTicket);
        json.addProperty("playFabId", playFabToken.playFabId);
        if (this.prevStep != null) {
            json.add(this.prevStep.name, (JsonElement)this.prevStep.toJson(playFabToken.xblXsts));
        }
        return json;
    }

    public static final class PlayFabToken
    extends AbstractStep.StepResult<StepXblXstsToken.XblXsts<?>> {
        private final long expireTimeMs;
        private final String entityToken;
        private final String entityId;
        private final String sessionTicket;
        private final String playFabId;
        private final StepXblXstsToken.XblXsts<?> xblXsts;

        @Override
        protected StepXblXstsToken.XblXsts<?> prevResult() {
            return this.xblXsts;
        }

        @Override
        public boolean isExpired() {
            return this.expireTimeMs <= System.currentTimeMillis();
        }

        @Generated
        public PlayFabToken(long expireTimeMs, String entityToken, String entityId, String sessionTicket, String playFabId, StepXblXstsToken.XblXsts<?> xblXsts) {
            this.expireTimeMs = expireTimeMs;
            this.entityToken = entityToken;
            this.entityId = entityId;
            this.sessionTicket = sessionTicket;
            this.playFabId = playFabId;
            this.xblXsts = xblXsts;
        }

        @Generated
        public long getExpireTimeMs() {
            return this.expireTimeMs;
        }

        @Generated
        public String getEntityToken() {
            return this.entityToken;
        }

        @Generated
        public String getEntityId() {
            return this.entityId;
        }

        @Generated
        public String getSessionTicket() {
            return this.sessionTicket;
        }

        @Generated
        public String getPlayFabId() {
            return this.playFabId;
        }

        @Generated
        public StepXblXstsToken.XblXsts<?> getXblXsts() {
            return this.xblXsts;
        }

        @Generated
        public String toString() {
            return "StepPlayFabToken.PlayFabToken(expireTimeMs=" + this.getExpireTimeMs() + ", entityToken=" + this.getEntityToken() + ", entityId=" + this.getEntityId() + ", sessionTicket=" + this.getSessionTicket() + ", playFabId=" + this.getPlayFabId() + ", xblXsts=" + this.getXblXsts() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlayFabToken)) {
                return false;
            }
            PlayFabToken other = (PlayFabToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
                return false;
            }
            String this$entityToken = this.getEntityToken();
            String other$entityToken = other.getEntityToken();
            if (this$entityToken == null ? other$entityToken != null : !this$entityToken.equals(other$entityToken)) {
                return false;
            }
            String this$entityId = this.getEntityId();
            String other$entityId = other.getEntityId();
            if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
                return false;
            }
            String this$sessionTicket = this.getSessionTicket();
            String other$sessionTicket = other.getSessionTicket();
            if (this$sessionTicket == null ? other$sessionTicket != null : !this$sessionTicket.equals(other$sessionTicket)) {
                return false;
            }
            String this$playFabId = this.getPlayFabId();
            String other$playFabId = other.getPlayFabId();
            if (this$playFabId == null ? other$playFabId != null : !this$playFabId.equals(other$playFabId)) {
                return false;
            }
            StepXblXstsToken.XblXsts<?> this$xblXsts = this.getXblXsts();
            StepXblXstsToken.XblXsts<?> other$xblXsts = other.getXblXsts();
            return !(this$xblXsts == null ? other$xblXsts != null : !this$xblXsts.equals(other$xblXsts));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PlayFabToken;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expireTimeMs = this.getExpireTimeMs();
            result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
            String $entityToken = this.getEntityToken();
            result = result * 59 + ($entityToken == null ? 43 : $entityToken.hashCode());
            String $entityId = this.getEntityId();
            result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
            String $sessionTicket = this.getSessionTicket();
            result = result * 59 + ($sessionTicket == null ? 43 : $sessionTicket.hashCode());
            String $playFabId = this.getPlayFabId();
            result = result * 59 + ($playFabId == null ? 43 : $playFabId.hashCode());
            StepXblXstsToken.XblXsts<?> $xblXsts = this.getXblXsts();
            result = result * 59 + ($xblXsts == null ? 43 : $xblXsts.hashCode());
            return result;
        }
    }
}

