/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.msa;

import com.google.gson.JsonObject;
import java.time.Instant;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.function.Consumer;
import lombok.Generated;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.content.impl.URLEncodedFormContent;
import net.lenni0451.commons.httpclient.handler.HttpResponseHandler;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.responsehandler.MsaResponseHandler;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.msa.InitialPreparationStep;
import net.raphimc.minecraftauth.util.OAuthEnvironment;
import net.raphimc.minecraftauth.util.logging.ILogger;

public class StepMsaDeviceCode
extends InitialPreparationStep<MsaDeviceCodeCallback, MsaDeviceCode> {
    public StepMsaDeviceCode(AbstractStep.ApplicationDetails applicationDetails) {
        super("msaDeviceCode", applicationDetails);
    }

    @Override
    protected MsaDeviceCode execute(ILogger logger, HttpClient httpClient, MsaDeviceCodeCallback msaDeviceCodeCallback) throws Exception {
        logger.info(this, "Getting device code for MSA login...");
        if (msaDeviceCodeCallback == null) {
            throw new IllegalStateException("Missing StepMsaDeviceCode.MsaDeviceCodeCallback input");
        }
        HashMap<String, String> postData = new HashMap<String, String>();
        postData.put("client_id", this.applicationDetails.getClientId());
        postData.put("scope", this.applicationDetails.getScope());
        if (this.applicationDetails.getOAuthEnvironment() == OAuthEnvironment.LIVE) {
            postData.put("response_type", "device_code");
        }
        PostRequest postRequest = new PostRequest(this.applicationDetails.getOAuthEnvironment().getDeviceCodeUrl());
        postRequest.setContent((HttpContent)new URLEncodedFormContent(postData));
        JsonObject obj = (JsonObject)httpClient.execute((HttpRequest)postRequest, (HttpResponseHandler)new MsaResponseHandler());
        MsaDeviceCode msaDeviceCode = new MsaDeviceCode(System.currentTimeMillis() + obj.get("expires_in").getAsLong() * 1000L, obj.get("interval").getAsLong() * 1000L, obj.get("device_code").getAsString(), obj.get("user_code").getAsString(), obj.get("verification_uri").getAsString());
        logger.info(this, "Got MSA device code, expires: " + Instant.ofEpochMilli(msaDeviceCode.getExpireTimeMs()).atZone(ZoneId.systemDefault()));
        msaDeviceCodeCallback.callback.accept(msaDeviceCode);
        return msaDeviceCode;
    }

    public static final class MsaDeviceCodeCallback
    extends AbstractStep.InitialInput {
        private final Consumer<MsaDeviceCode> callback;

        @Generated
        public MsaDeviceCodeCallback(Consumer<MsaDeviceCode> callback) {
            this.callback = callback;
        }

        @Generated
        public Consumer<MsaDeviceCode> getCallback() {
            return this.callback;
        }

        @Generated
        public String toString() {
            return "StepMsaDeviceCode.MsaDeviceCodeCallback(callback=" + this.getCallback() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MsaDeviceCodeCallback)) {
                return false;
            }
            MsaDeviceCodeCallback other = (MsaDeviceCodeCallback)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Consumer<MsaDeviceCode> this$callback = this.getCallback();
            Consumer<MsaDeviceCode> other$callback = other.getCallback();
            return !(this$callback == null ? other$callback != null : !this$callback.equals(other$callback));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MsaDeviceCodeCallback;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Consumer<MsaDeviceCode> $callback = this.getCallback();
            result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
            return result;
        }
    }

    public static final class MsaDeviceCode
    extends AbstractStep.InitialInput {
        private final long expireTimeMs;
        private final long intervalMs;
        private final String deviceCode;
        private final String userCode;
        private final String verificationUri;

        @Override
        public boolean isExpired() {
            return this.expireTimeMs <= System.currentTimeMillis();
        }

        public String getDirectVerificationUri() {
            return this.verificationUri + "?otc=" + this.userCode;
        }

        @Generated
        public MsaDeviceCode(long expireTimeMs, long intervalMs, String deviceCode, String userCode, String verificationUri) {
            this.expireTimeMs = expireTimeMs;
            this.intervalMs = intervalMs;
            this.deviceCode = deviceCode;
            this.userCode = userCode;
            this.verificationUri = verificationUri;
        }

        @Generated
        public long getExpireTimeMs() {
            return this.expireTimeMs;
        }

        @Generated
        public long getIntervalMs() {
            return this.intervalMs;
        }

        @Generated
        public String getDeviceCode() {
            return this.deviceCode;
        }

        @Generated
        public String getUserCode() {
            return this.userCode;
        }

        @Generated
        public String getVerificationUri() {
            return this.verificationUri;
        }

        @Generated
        public String toString() {
            return "StepMsaDeviceCode.MsaDeviceCode(expireTimeMs=" + this.getExpireTimeMs() + ", intervalMs=" + this.getIntervalMs() + ", deviceCode=" + this.getDeviceCode() + ", userCode=" + this.getUserCode() + ", verificationUri=" + this.getVerificationUri() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MsaDeviceCode)) {
                return false;
            }
            MsaDeviceCode other = (MsaDeviceCode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
                return false;
            }
            if (this.getIntervalMs() != other.getIntervalMs()) {
                return false;
            }
            String this$deviceCode = this.getDeviceCode();
            String other$deviceCode = other.getDeviceCode();
            if (this$deviceCode == null ? other$deviceCode != null : !this$deviceCode.equals(other$deviceCode)) {
                return false;
            }
            String this$userCode = this.getUserCode();
            String other$userCode = other.getUserCode();
            if (this$userCode == null ? other$userCode != null : !this$userCode.equals(other$userCode)) {
                return false;
            }
            String this$verificationUri = this.getVerificationUri();
            String other$verificationUri = other.getVerificationUri();
            return !(this$verificationUri == null ? other$verificationUri != null : !this$verificationUri.equals(other$verificationUri));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MsaDeviceCode;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expireTimeMs = this.getExpireTimeMs();
            result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
            long $intervalMs = this.getIntervalMs();
            result = result * 59 + (int)($intervalMs >>> 32 ^ $intervalMs);
            String $deviceCode = this.getDeviceCode();
            result = result * 59 + ($deviceCode == null ? 43 : $deviceCode.hashCode());
            String $userCode = this.getUserCode();
            result = result * 59 + ($userCode == null ? 43 : $userCode.hashCode());
            String $verificationUri = this.getVerificationUri();
            result = result * 59 + ($verificationUri == null ? 43 : $verificationUri.hashCode());
            return result;
        }
    }
}

