/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.service.realms;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.CookieManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.constants.ContentTypes;
import net.lenni0451.commons.httpclient.handler.HttpResponseHandler;
import net.lenni0451.commons.httpclient.handler.ThrowingResponseHandler;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.requests.impl.GetRequest;
import net.raphimc.minecraftauth.responsehandler.RealmsResponseHandler;
import net.raphimc.minecraftauth.service.realms.model.RealmsWorld;

public abstract class AbstractRealmsService {
    public static final String CLIENT_COMPATIBLE_URL = "https://$HOST/mco/client/compatible";
    public static final String WORLDS_URL = "https://$HOST/worlds";
    protected final String host;
    protected final HttpClient httpClient;
    protected final CookieManager cookieManager;

    public AbstractRealmsService(String host, HttpClient httpClient, CookieManager cookieManager) {
        this.host = host;
        this.httpClient = httpClient;
        this.cookieManager = cookieManager;
    }

    public CompletableFuture<Boolean> isAvailable() {
        return CompletableFuture.supplyAsync(new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                GetRequest getRequest = new GetRequest(AbstractRealmsService.CLIENT_COMPATIBLE_URL.replace("$HOST", AbstractRealmsService.this.host));
                getRequest.setCookieManager(AbstractRealmsService.this.cookieManager);
                getRequest.setHeader("Accept", ContentTypes.TEXT_PLAIN.getMimeType());
                AbstractRealmsService.this.addRequestHeaders((HttpRequest)getRequest);
                String response = ((HttpResponse)AbstractRealmsService.this.httpClient.execute((HttpRequest)getRequest, (HttpResponseHandler)new ThrowingResponseHandler())).getContentAsString();
                return response.equals("COMPATIBLE");
            }
        });
    }

    public CompletableFuture<List<RealmsWorld>> getWorlds() {
        return CompletableFuture.supplyAsync(new Supplier<List<RealmsWorld>>(){

            @Override
            public List<RealmsWorld> get() {
                GetRequest getRequest = new GetRequest(AbstractRealmsService.WORLDS_URL.replace("$HOST", AbstractRealmsService.this.host));
                getRequest.setCookieManager(AbstractRealmsService.this.cookieManager);
                AbstractRealmsService.this.addRequestHeaders((HttpRequest)getRequest);
                JsonObject obj = (JsonObject)AbstractRealmsService.this.httpClient.execute((HttpRequest)getRequest, (HttpResponseHandler)new RealmsResponseHandler());
                ArrayList<RealmsWorld> realmsWorlds = new ArrayList<RealmsWorld>();
                for (JsonElement server : obj.getAsJsonArray("servers")) {
                    realmsWorlds.add(RealmsWorld.fromJson(server.getAsJsonObject()));
                }
                return realmsWorlds;
            }
        });
    }

    public abstract CompletableFuture<String> joinWorld(RealmsWorld var1);

    protected abstract void addRequestHeaders(HttpRequest var1);
}

