/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.service.realms;

import com.google.gson.JsonObject;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.handler.HttpResponseHandler;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.requests.impl.GetRequest;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.responsehandler.RealmsResponseHandler;
import net.raphimc.minecraftauth.service.realms.AbstractRealmsService;
import net.raphimc.minecraftauth.service.realms.model.RealmsWorld;
import net.raphimc.minecraftauth.step.java.StepMCProfile;

public class JavaRealmsService
extends AbstractRealmsService {
    public static final String JOIN_WORLD_URL = "https://pc.realms.minecraft.net/worlds/v1/$ID/join/pc";
    public static final String AGREE_TOS_URL = "https://pc.realms.minecraft.net/mco/tos/agreed";
    private final boolean isSnapshot;

    public JavaRealmsService(HttpClient httpClient, String clientVersion, StepMCProfile.MCProfile mcProfile) {
        super("pc.realms.minecraft.net", httpClient, new CookieManager());
        this.isSnapshot = !clientVersion.matches("\\d+\\.\\d+(\\.\\d+)?");
        this.cookieManager.getCookieStore().add(null, this.createCookie("sid", "token:" + mcProfile.getMcToken().getAccessToken() + ':' + mcProfile.getId().toString().replace("-", "")));
        this.cookieManager.getCookieStore().add(null, this.createCookie("user", mcProfile.getName()));
        this.cookieManager.getCookieStore().add(null, this.createCookie("version", clientVersion));
    }

    @Override
    public CompletableFuture<String> joinWorld(final RealmsWorld realmsWorld) {
        return CompletableFuture.supplyAsync(new Supplier<String>(){

            @Override
            public String get() {
                GetRequest getRequest = new GetRequest(JavaRealmsService.JOIN_WORLD_URL.replace("$ID", String.valueOf(realmsWorld.getId())));
                getRequest.setCookieManager(JavaRealmsService.this.cookieManager);
                JavaRealmsService.this.addRequestHeaders((HttpRequest)getRequest);
                JsonObject obj = (JsonObject)JavaRealmsService.this.httpClient.execute((HttpRequest)getRequest, (HttpResponseHandler)new RealmsResponseHandler());
                return obj.get("address").getAsString();
            }
        });
    }

    public CompletableFuture<Void> acceptTos() {
        return CompletableFuture.runAsync(new Runnable(){

            @Override
            public void run() {
                PostRequest postRequest = new PostRequest(JavaRealmsService.AGREE_TOS_URL);
                postRequest.setCookieManager(JavaRealmsService.this.cookieManager);
                JavaRealmsService.this.addRequestHeaders((HttpRequest)postRequest);
                JavaRealmsService.this.httpClient.execute((HttpRequest)postRequest, (HttpResponseHandler)new RealmsResponseHandler());
            }
        });
    }

    @Override
    protected void addRequestHeaders(HttpRequest httpRequest) {
        httpRequest.setHeader("Is-Prerelease", String.valueOf(this.isSnapshot));
    }

    private HttpCookie createCookie(String name, String value) {
        HttpCookie cookie = new HttpCookie(name, value);
        cookie.setDomain(this.host);
        cookie.setPath("/");
        return cookie;
    }
}

