/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.msa;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebView;
import javax.swing.JFrame;
import lombok.Generated;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.utils.URLWrapper;
import net.raphimc.minecraftauth.responsehandler.exception.MsaRequestException;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.msa.MsaCodeStep;
import net.raphimc.minecraftauth.util.logging.ILogger;

public class StepJfxWebViewMsaCode
extends MsaCodeStep<JavaFxWebView> {
    private final int timeout;

    public StepJfxWebViewMsaCode(AbstractStep.ApplicationDetails applicationDetails, int timeout) {
        super(applicationDetails);
        this.timeout = timeout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected MsaCodeStep.MsaCode execute(ILogger logger, HttpClient httpClient, JavaFxWebView javaFxWebViewCallback) throws Exception {
        logger.info(this, "Opening JavaFX WebView window for MSA login...");
        URL authenticationUrl = new URLWrapper(this.applicationDetails.getOAuthEnvironment().getAuthorizeUrl()).wrapQuery().addQueries(this.applicationDetails.getOAuthParameters()).apply().toURL();
        final CompletableFuture msaCodeFuture = new CompletableFuture();
        JFXPanel jfxPanel = new JFXPanel();
        JFrame window = new JFrame("MinecraftAuth - Microsoft Login");
        window.setDefaultCloseOperation(0);
        window.setSize(800, 600);
        window.setLocationRelativeTo(null);
        window.setResizable(false);
        window.setContentPane((Container)jfxPanel);
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!msaCodeFuture.isDone()) {
                    msaCodeFuture.completeExceptionally(new UserClosedWindowException());
                }
            }
        });
        Platform.runLater(() -> {
            WebView webView = new WebView();
            webView.setContextMenuEnabled(false);
            httpClient.getFirstHeader("User-Agent").ifPresent(s -> webView.getEngine().setUserAgent(s));
            webView.getEngine().load(authenticationUrl.toString());
            webView.getEngine().locationProperty().addListener((observable, oldValue, newValue) -> {
                try {
                    if (newValue.startsWith(this.applicationDetails.getRedirectUri())) {
                        Map parameters = new URLWrapper(newValue).wrapQuery().getQueries();
                        if (parameters.containsKey("error") && parameters.containsKey("error_description")) {
                            HttpResponse fakeResponse = new HttpResponse(null, 500, new byte[0], Collections.emptyMap());
                            throw new MsaRequestException(fakeResponse, (String)parameters.get("error"), (String)parameters.get("error_description"));
                        }
                        if (!parameters.containsKey("code")) {
                            throw new IllegalStateException("Could not extract MSA Code from response url");
                        }
                        msaCodeFuture.complete(new MsaCodeStep.MsaCode((String)parameters.get("code")));
                    }
                }
                catch (Throwable e) {
                    msaCodeFuture.completeExceptionally(e);
                }
            });
            jfxPanel.setScene(new Scene((Parent)webView, (double)window.getWidth(), (double)window.getHeight()));
            if (javaFxWebViewCallback == null) {
                window.setVisible(true);
            } else {
                javaFxWebViewCallback.openCallback.accept(window);
            }
        });
        try {
            MsaCodeStep.MsaCode msaCode = (MsaCodeStep.MsaCode)msaCodeFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            logger.info(this, "Got MSA Code");
            MsaCodeStep.MsaCode msaCode2 = msaCode;
            return msaCode2;
        }
        catch (TimeoutException e) {
            throw new TimeoutException("MSA login timed out");
        }
        catch (ExecutionException e) {
            if (e.getCause() == null) throw e;
            throw e.getCause();
        }
        finally {
            if (javaFxWebViewCallback == null) {
                window.dispose();
            } else {
                javaFxWebViewCallback.closeCallback.accept(window);
            }
        }
    }

    public static class UserClosedWindowException
    extends Exception {
        public UserClosedWindowException() {
            super("User closed login window");
        }
    }

    public static final class JavaFxWebView
    extends AbstractStep.InitialInput {
        private final Consumer<JFrame> openCallback;
        private final Consumer<JFrame> closeCallback;

        public JavaFxWebView() {
            this.openCallback = window -> window.setVisible(true);
            this.closeCallback = Window::dispose;
        }

        @Deprecated
        public JavaFxWebView(BiConsumer<JFrame, WebView> openCallback, Consumer<JFrame> closeCallback) {
            this.openCallback = window -> {
                WebView webView = (WebView)((JFXPanel)window.getContentPane()).getScene().getRoot();
                openCallback.accept((JFrame)window, webView);
            };
            this.closeCallback = closeCallback;
        }

        @Generated
        public Consumer<JFrame> getOpenCallback() {
            return this.openCallback;
        }

        @Generated
        public Consumer<JFrame> getCloseCallback() {
            return this.closeCallback;
        }

        @Generated
        public String toString() {
            return "StepJfxWebViewMsaCode.JavaFxWebView(openCallback=" + this.getOpenCallback() + ", closeCallback=" + this.getCloseCallback() + ")";
        }

        @Generated
        public JavaFxWebView(Consumer<JFrame> openCallback, Consumer<JFrame> closeCallback) {
            this.openCallback = openCallback;
            this.closeCallback = closeCallback;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JavaFxWebView)) {
                return false;
            }
            JavaFxWebView other = (JavaFxWebView)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Consumer<JFrame> this$openCallback = this.getOpenCallback();
            Consumer<JFrame> other$openCallback = other.getOpenCallback();
            if (this$openCallback == null ? other$openCallback != null : !this$openCallback.equals(other$openCallback)) {
                return false;
            }
            Consumer<JFrame> this$closeCallback = this.getCloseCallback();
            Consumer<JFrame> other$closeCallback = other.getCloseCallback();
            return !(this$closeCallback == null ? other$closeCallback != null : !this$closeCallback.equals(other$closeCallback));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JavaFxWebView;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Consumer<JFrame> $openCallback = this.getOpenCallback();
            result = result * 59 + ($openCallback == null ? 43 : $openCallback.hashCode());
            Consumer<JFrame> $closeCallback = this.getCloseCallback();
            result = result * 59 + ($closeCallback == null ? 43 : $closeCallback.hashCode());
            return result;
        }
    }
}

