/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.xbl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Map;
import lombok.Generated;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.handler.HttpResponseHandler;
import net.lenni0451.commons.httpclient.model.HttpHeader;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.responsehandler.XblResponseHandler;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.xbl.StepXblTitleToken;
import net.raphimc.minecraftauth.step.xbl.StepXblUserToken;
import net.raphimc.minecraftauth.step.xbl.StepXblXstsToken;
import net.raphimc.minecraftauth.step.xbl.session.StepFullXblSession;
import net.raphimc.minecraftauth.step.xbl.session.StepInitialXblSession;
import net.raphimc.minecraftauth.util.CryptUtil;
import net.raphimc.minecraftauth.util.JsonContent;
import net.raphimc.minecraftauth.util.logging.ILogger;

public class StepXblSisuAuthentication
extends AbstractStep<StepInitialXblSession.InitialXblSession, XblSisuTokens> {
    public static final String XBL_SISU_URL = "https://sisu.xboxlive.com/authorize";
    private final String relyingParty;

    public StepXblSisuAuthentication(AbstractStep<?, StepInitialXblSession.InitialXblSession> prevStep, String relyingParty) {
        super("xblSisuAuthentication", prevStep);
        this.relyingParty = relyingParty;
    }

    @Override
    protected XblSisuTokens execute(ILogger logger, HttpClient httpClient, StepInitialXblSession.InitialXblSession initialXblSession) throws Exception {
        logger.info(this, "Authenticating with Xbox Live using SISU...");
        if (initialXblSession.getXblDeviceToken() == null) {
            throw new IllegalStateException("An XBL Device Token is needed for SISU authentication");
        }
        if (!this.applicationDetails.isTitleClientId()) {
            throw new IllegalStateException("A Title Client ID is needed for SISU authentication");
        }
        JsonObject postData = new JsonObject();
        postData.addProperty("AccessToken", "t=" + initialXblSession.getMsaToken().getAccessToken());
        postData.addProperty("DeviceToken", initialXblSession.getXblDeviceToken().getToken());
        postData.addProperty("AppId", this.applicationDetails.getClientId());
        postData.add("ProofKey", (JsonElement)CryptUtil.getProofKey(initialXblSession.getXblDeviceToken().getPublicKey()));
        postData.addProperty("SiteName", "user.auth.xboxlive.com");
        postData.addProperty("RelyingParty", this.relyingParty);
        postData.addProperty("Sandbox", "RETAIL");
        postData.addProperty("UseModernGamertag", Boolean.valueOf(true));
        PostRequest postRequest = new PostRequest(XBL_SISU_URL);
        postRequest.setContent((HttpContent)new JsonContent(postData));
        postRequest.setHeader(new HttpHeader[]{CryptUtil.getSignatureHeader((HttpRequest)postRequest, initialXblSession.getXblDeviceToken().getPrivateKey())});
        JsonObject obj = (JsonObject)httpClient.execute((HttpRequest)postRequest, (HttpResponseHandler)new XblResponseHandler());
        StepXblTitleToken.XblTitleToken xblTitleToken = StepXblTitleToken.XblTitleToken.fromMicrosoftJson(obj.getAsJsonObject("TitleToken"), initialXblSession);
        StepXblUserToken.XblUserToken xblUserToken = StepXblUserToken.XblUserToken.fromMicrosoftJson(obj.getAsJsonObject("UserToken"), initialXblSession);
        StepFullXblSession.FullXblSession fullXblSession = new StepFullXblSession.FullXblSession(xblUserToken, xblTitleToken);
        StepXblXstsToken.XblXstsToken xblXstsToken = StepXblXstsToken.XblXstsToken.fromMicrosoftJson(obj.getAsJsonObject("AuthorizationToken"), fullXblSession);
        XblSisuTokens xblSisuTokens = new XblSisuTokens(xblUserToken, xblTitleToken, xblXstsToken, initialXblSession);
        logger.info(this, "Got XBL User+Title+XSTS Token, expires: " + Instant.ofEpochMilli(xblSisuTokens.getExpireTimeMs()).atZone(ZoneId.systemDefault()));
        return xblSisuTokens;
    }

    @Override
    public XblSisuTokens fromJson(JsonObject json) {
        StepInitialXblSession.InitialXblSession initialXblSession = this.prevStep != null ? (StepInitialXblSession.InitialXblSession)this.prevStep.fromJson(json.getAsJsonObject(this.prevStep.name)) : null;
        StepXblUserToken.XblUserToken xblUserToken = StepXblUserToken.XblUserToken.fromJson(json.getAsJsonObject("userToken"), initialXblSession);
        StepXblTitleToken.XblTitleToken xblTitleToken = StepXblTitleToken.XblTitleToken.fromJson(json.getAsJsonObject("titleToken"), initialXblSession);
        StepFullXblSession.FullXblSession fullXblSession = new StepFullXblSession.FullXblSession(xblUserToken, xblTitleToken);
        StepXblXstsToken.XblXstsToken xblXstsToken = StepXblXstsToken.XblXstsToken.fromJson(json.getAsJsonObject("xstsToken"), fullXblSession);
        return new XblSisuTokens(xblUserToken, xblTitleToken, xblXstsToken, initialXblSession);
    }

    @Override
    public JsonObject toJson(XblSisuTokens xblSisuTokens) {
        JsonObject json = new JsonObject();
        json.add("userToken", (JsonElement)StepXblUserToken.XblUserToken.toJson(xblSisuTokens.userToken));
        json.add("titleToken", (JsonElement)StepXblTitleToken.XblTitleToken.toJson(xblSisuTokens.titleToken));
        json.add("xstsToken", (JsonElement)StepXblXstsToken.XblXstsToken.toJson(xblSisuTokens.xstsToken));
        if (this.prevStep != null) {
            json.add(this.prevStep.name, (JsonElement)this.prevStep.toJson(xblSisuTokens.initialXblSession));
        }
        return json;
    }

    public static final class XblSisuTokens
    extends StepXblXstsToken.XblXsts<StepInitialXblSession.InitialXblSession> {
        private final StepXblUserToken.XblUserToken userToken;
        private final StepXblTitleToken.XblTitleToken titleToken;
        private final StepXblXstsToken.XblXstsToken xstsToken;
        private final StepInitialXblSession.InitialXblSession initialXblSession;

        @Override
        public long getExpireTimeMs() {
            return Math.min(Math.min(this.userToken.getExpireTimeMs(), this.titleToken.getExpireTimeMs()), this.xstsToken.getExpireTimeMs());
        }

        @Override
        public String getToken() {
            return this.xstsToken.getToken();
        }

        @Override
        public String getUserHash() {
            return this.xstsToken.getUserHash();
        }

        @Override
        public Map<String, String> getDisplayClaims() {
            return this.xstsToken.getDisplayClaims();
        }

        @Override
        public StepFullXblSession.FullXblSession getFullXblSession() {
            return this.xstsToken.getFullXblSession();
        }

        @Override
        protected StepInitialXblSession.InitialXblSession prevResult() {
            return this.initialXblSession;
        }

        @Override
        public boolean isExpired() {
            return this.userToken.isExpired() || this.titleToken.isExpired() || this.xstsToken.isExpired() || this.prevResult().isExpired();
        }

        @Override
        public boolean isExpiredOrOutdated() {
            return this.userToken.isExpiredOrOutdated() || this.titleToken.isExpiredOrOutdated() || this.xstsToken.isExpiredOrOutdated() || this.prevResult().isExpiredOrOutdated();
        }

        @Generated
        public XblSisuTokens(StepXblUserToken.XblUserToken userToken, StepXblTitleToken.XblTitleToken titleToken, StepXblXstsToken.XblXstsToken xstsToken, StepInitialXblSession.InitialXblSession initialXblSession) {
            this.userToken = userToken;
            this.titleToken = titleToken;
            this.xstsToken = xstsToken;
            this.initialXblSession = initialXblSession;
        }

        @Generated
        public StepXblUserToken.XblUserToken getUserToken() {
            return this.userToken;
        }

        @Generated
        public StepXblTitleToken.XblTitleToken getTitleToken() {
            return this.titleToken;
        }

        @Generated
        public StepXblXstsToken.XblXstsToken getXstsToken() {
            return this.xstsToken;
        }

        @Override
        @Generated
        public StepInitialXblSession.InitialXblSession getInitialXblSession() {
            return this.initialXblSession;
        }

        @Generated
        public String toString() {
            return "StepXblSisuAuthentication.XblSisuTokens(userToken=" + this.getUserToken() + ", titleToken=" + this.getTitleToken() + ", xstsToken=" + this.getXstsToken() + ", initialXblSession=" + this.getInitialXblSession() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XblSisuTokens)) {
                return false;
            }
            XblSisuTokens other = (XblSisuTokens)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StepXblUserToken.XblUserToken this$userToken = this.getUserToken();
            StepXblUserToken.XblUserToken other$userToken = other.getUserToken();
            if (this$userToken == null ? other$userToken != null : !((Object)this$userToken).equals(other$userToken)) {
                return false;
            }
            StepXblTitleToken.XblTitleToken this$titleToken = this.getTitleToken();
            StepXblTitleToken.XblTitleToken other$titleToken = other.getTitleToken();
            if (this$titleToken == null ? other$titleToken != null : !((Object)this$titleToken).equals(other$titleToken)) {
                return false;
            }
            StepXblXstsToken.XblXstsToken this$xstsToken = this.getXstsToken();
            StepXblXstsToken.XblXstsToken other$xstsToken = other.getXstsToken();
            if (this$xstsToken == null ? other$xstsToken != null : !((Object)this$xstsToken).equals(other$xstsToken)) {
                return false;
            }
            StepInitialXblSession.InitialXblSession this$initialXblSession = this.getInitialXblSession();
            StepInitialXblSession.InitialXblSession other$initialXblSession = other.getInitialXblSession();
            return !(this$initialXblSession == null ? other$initialXblSession != null : !((Object)this$initialXblSession).equals(other$initialXblSession));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof XblSisuTokens;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StepXblUserToken.XblUserToken $userToken = this.getUserToken();
            result = result * 59 + ($userToken == null ? 43 : ((Object)$userToken).hashCode());
            StepXblTitleToken.XblTitleToken $titleToken = this.getTitleToken();
            result = result * 59 + ($titleToken == null ? 43 : ((Object)$titleToken).hashCode());
            StepXblXstsToken.XblXstsToken $xstsToken = this.getXstsToken();
            result = result * 59 + ($xstsToken == null ? 43 : ((Object)$xstsToken).hashCode());
            StepInitialXblSession.InitialXblSession $initialXblSession = this.getInitialXblSession();
            result = result * 59 + ($initialXblSession == null ? 43 : ((Object)$initialXblSession).hashCode());
            return result;
        }
    }
}

