/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.bedrock.request;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.KeyPair;
import java.util.Base64;
import net.lenni0451.commons.gson.elements.GsonArray;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.bedrock.model.MinecraftCertificateChain;
import net.raphimc.minecraftauth.bedrock.responsehandler.MinecraftResponseHandler;
import net.raphimc.minecraftauth.util.http.content.JsonContent;
import net.raphimc.minecraftauth.xbl.model.XblXstsToken;

public class MinecraftAuthenticationRequest
extends PostRequest
implements MinecraftResponseHandler<MinecraftCertificateChain> {
    public MinecraftAuthenticationRequest(XblXstsToken xstsToken, KeyPair ecdsa384KeyPair) throws MalformedURLException {
        super("https://multiplayer.minecraft.net/authentication");
        JsonObject postData = new JsonObject();
        postData.addProperty("identityPublicKey", Base64.getEncoder().encodeToString(ecdsa384KeyPair.getPublic().getEncoded()));
        this.setContent((HttpContent)new JsonContent(postData));
        this.setHeader("Authorization", xstsToken.getAuthorizationHeader());
    }

    @Override
    public MinecraftCertificateChain handle(HttpResponse response, GsonObject json) throws IOException {
        GsonArray chain = json.reqArray("chain");
        if (chain.size() != 2) {
            throw new IllegalStateException("Invalid certificate chain length: " + chain.size());
        }
        return new MinecraftCertificateChain(chain.get(0).asString(), chain.get(1).asString());
    }
}

